/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.Iterator;
import java.util.LinkedHashSet;
import prefuse.data.Tuple;
import prefuse.data.event.EventConstants;
import prefuse.data.tuple.AbstractTupleSet;

public class DefaultTupleSet
extends AbstractTupleSet
implements EventConstants {
    protected LinkedHashSet m_tuples = new LinkedHashSet();

    public int getTupleCount() {
        return this.m_tuples.size();
    }

    public Tuple addTuple(Tuple t) {
        if ((t = this.addInternal(t)) != null) {
            this.fireTupleEvent(t, 1);
        }
        return t;
    }

    public Tuple setTuple(Tuple t) {
        Tuple[] tupleArray;
        Tuple[] rem = this.clearInternal();
        if ((t = this.addInternal(t)) == null) {
            tupleArray = null;
        } else {
            Tuple[] tupleArray2 = new Tuple[1];
            tupleArray = tupleArray2;
            tupleArray2[0] = t;
        }
        Tuple[] add = tupleArray;
        this.fireTupleEvent(add, rem);
        return t;
    }

    protected final Tuple addInternal(Tuple t) {
        if (this.m_tuples.add(t)) {
            return t;
        }
        return null;
    }

    public boolean containsTuple(Tuple t) {
        return this.m_tuples.contains(t);
    }

    public boolean removeTuple(Tuple t) {
        boolean b = this.removeInternal(t);
        if (b) {
            this.fireTupleEvent(t, -1);
        }
        return b;
    }

    protected final boolean removeInternal(Tuple t) {
        return this.m_tuples.remove(t);
    }

    public void clear() {
        if (this.getTupleCount() > 0) {
            Tuple[] t = this.clearInternal();
            this.fireTupleEvent(null, t);
        }
    }

    public Tuple[] clearInternal() {
        Tuple[] t = new Tuple[this.getTupleCount()];
        Iterator iter = this.tuples();
        int i = 0;
        while (iter.hasNext()) {
            t[i] = (Tuple)iter.next();
            ++i;
        }
        this.m_tuples.clear();
        return t;
    }

    public Iterator tuples() {
        return this.m_tuples.iterator();
    }

    public Tuple[] toArray() {
        Tuple[] t = new Tuple[this.getTupleCount()];
        this.m_tuples.toArray(t);
        return t;
    }
}

