/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.visual.VisualItem;

public class CollapsedStackLayout
extends Layout {
    private String m_polyField;

    public CollapsedStackLayout(String group) {
        this(group, "_polygon");
    }

    public CollapsedStackLayout(String group, String field) {
        super(group);
        this.m_polyField = field;
    }

    public void run(double frac) {
        VisualItem lastItem = null;
        float maxY = (float)this.getLayoutBounds().getMaxY();
        Iterator iter = ((Table)this.m_vis.getGroup(this.m_group)).tuplesReversed();
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            boolean prev = item.isStartVisible();
            boolean cur = item.isVisible();
            if (!prev && cur) {
                float[] f = (float[])item.get(this.m_polyField);
                if (f == null) continue;
                if (lastItem == null) {
                    for (int i = 1; i < f.length; i += 2) {
                        f[i] = maxY;
                    }
                    continue;
                }
                float[] l = (float[])lastItem.get(this.m_polyField);
                for (int i = 1; i < f.length / 2; i += 2) {
                    float f2 = l[i];
                    f[f.length - i] = f2;
                    f[i] = f2;
                }
                continue;
            }
            if (!prev || !cur) continue;
            lastItem = item;
        }
    }
}

