/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco;

import com.sun.encoder.Encoder;
import com.sun.encoder.EncoderConfigurationException;
import com.sun.encoder.EncoderException;
import com.sun.encoder.EncoderProperties;
import com.sun.encoder.EncoderType;
import com.sun.encoder.MetaRef;
import com.sun.encoder.coco.runtime.MarshalHandler;
import com.sun.encoder.coco.runtime.RuleNode;
import com.sun.encoder.coco.runtime.UnmarshalAdaptor;
import com.sun.encoder.runtime.ReaderInputStream;
import com.sun.encoder.runtime.WriterOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.xml.sax.InputSource;

class CocoEncoder
implements Encoder {
    private final EncoderType mType;
    private final EncoderProperties mProperties;
    private Transformer mTransformer;
    private RuleNode mTopRule;
    private URL mSchemaLocation;

    CocoEncoder(EncoderType type, EncoderProperties properties) {
        this.mType = type;
        this.mProperties = properties.immutable() ? properties : properties.cloneImmutable();
    }

    public Source decodeFromString(String input) throws EncoderException {
        return this.decodeFromString(input, null);
    }

    public String encodeToString(Source input) throws EncoderException {
        return this.encodeToString(input, null);
    }

    public Source decodeFromBytes(byte[] input) throws EncoderException {
        return this.decodeFromBytes(input, null);
    }

    public byte[] encodeToBytes(Source xmlSource) throws EncoderException {
        return this.encodeToBytes(xmlSource, null);
    }

    public Source decodeFromBytes(byte[] input, EncoderProperties properties) throws EncoderException {
        return this.decodeFromStream(new ByteArrayInputStream(input), properties);
    }

    public Source decodeFromReader(Reader input) throws EncoderException {
        return this.decodeFromReader(input, null);
    }

    public Source decodeFromReader(Reader reader, EncoderProperties properties) throws EncoderException {
        String charCoding;
        String string = charCoding = properties != null ? properties.getPreDecodeCharCoding() : null;
        if (charCoding == null && (charCoding = this.mProperties.getPreDecodeCharCoding()) == null && (charCoding = this.mTopRule.getContext().getPreDecodeCharCoding()) == null) {
            throw new EncoderException("The data nature of the COBOL Copybook encoder type is byte based but the pre-decoding character coding is not set for this encoder. Don't know how to convert character based data into byte based data.");
        }
        try {
            ReaderInputStream wrapper = new ReaderInputStream(reader, charCoding);
            return this.decodeFromStream((InputStream)wrapper, properties);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public Source decodeFromStream(InputStream input) throws EncoderException {
        return this.decodeFromStream(input, null);
    }

    public Source decodeFromStream(InputStream input, EncoderProperties properties) throws EncoderException {
        InputSource inputSource = new InputSource(input);
        inputSource.setPublicId("byte sequence data");
        UnmarshalAdaptor adaptor = new UnmarshalAdaptor(this.mSchemaLocation, this.mTopRule);
        return new SAXSource(adaptor, inputSource);
    }

    public Source decodeFromString(String input, EncoderProperties properties) throws EncoderException {
        return this.decodeFromReader(new StringReader(input), properties);
    }

    public byte[] encodeToBytes(Source input, EncoderProperties properties) throws EncoderException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.encodeToStream(input, new BufferedOutputStream(outStream), properties);
        return outStream.toByteArray();
    }

    public void encodeToStream(Source input, OutputStream output) throws EncoderException {
        this.encodeToStream(input, output, null);
    }

    public void encodeToStream(Source input, OutputStream output, EncoderProperties properties) throws EncoderException {
        SAXResult result = new SAXResult(new MarshalHandler(this.mTopRule, output));
        try {
            this.mTransformer.transform(input, result);
            output.flush();
        }
        catch (TransformerException e) {
            throw new EncoderException((Throwable)e);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public String encodeToString(Source input, EncoderProperties properties) throws EncoderException {
        StringWriter writer = new StringWriter();
        this.encodeToWriter(input, writer, properties);
        return ((Object)writer).toString();
    }

    public void encodeToWriter(Source input, Writer output) throws EncoderException {
        this.encodeToWriter(input, output, null);
    }

    public void encodeToWriter(Source input, Writer output, EncoderProperties properties) throws EncoderException {
        String charCoding;
        String string = charCoding = properties != null ? properties.getPostEncodeCharCoding() : null;
        if (charCoding == null && (charCoding = this.mProperties.getPostEncodeCharCoding()) == null && (charCoding = this.mTopRule.getContext().getPostEncodeCharCoding()) == null) {
            throw new EncoderException("The data nature of the COBOL Copybook encoder type is byte based but the post-encoding character coding is not set for this encoder. Don't know how to convert byte based data into character based data.");
        }
        try {
            WriterOutputStream wrapper = new WriterOutputStream(output, charCoding);
            this.encodeToStream(input, (OutputStream)wrapper, properties);
            wrapper.flushToWriter(true);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public boolean dispose() {
        this.mTopRule = null;
        return true;
    }

    public EncoderProperties getProperties() {
        return this.mProperties;
    }

    public EncoderType getType() {
        return this.mType;
    }

    void setMeta(MetaRef xsd) throws EncoderConfigurationException {
        try {
            SchemaTypeSystem schemaTS;
            if (xsd.getURL() != null) {
                XmlOptions options = new XmlOptions();
                options.put((Object)"COMPILE_DOWNLOAD_URLS", (Object)Boolean.TRUE);
                SchemaDocument schemaXmlObj = SchemaDocument.Factory.parse((URL)xsd.getURL());
                schemaTS = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{schemaXmlObj}, (SchemaTypeLoader)SchemaDocument.type.getTypeSystem(), (XmlOptions)options);
            } else {
                SchemaDocument schemaXmlObj = SchemaDocument.Factory.parse((File)new File(xsd.getPath()));
                schemaXmlObj.validate();
                schemaTS = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{schemaXmlObj}, (SchemaTypeLoader)SchemaDocument.type.getTypeSystem(), null);
            }
            QName qName = xsd.getRootElemName();
            if (qName == null) {
                throw new EncoderConfigurationException("Root element name cannot be null. path='" + xsd.getPath() + "'");
            }
            this.mTopRule = RuleNode.readRules(schemaTS, qName);
            if (this.mTopRule == null) {
                throw new EncoderConfigurationException("Unable to read metadata for '" + qName + "'");
            }
            this.mTransformer = TransformerFactory.newInstance().newTransformer();
            this.mSchemaLocation = xsd.getURL() != null ? xsd.getURL() : new File(xsd.getPath()).toURL();
        }
        catch (XmlException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }

    void setMeta(URL schemaLocation, SchemaGlobalElement rootElemName) throws EncoderConfigurationException {
        try {
            this.mTopRule = RuleNode.readRules(rootElemName.getTypeSystem(), rootElemName.getName());
            if (this.mTopRule == null) {
                throw new EncoderConfigurationException("Unable to read metadata for '" + rootElemName.getName() + "'");
            }
            this.mTransformer = TransformerFactory.newInstance().newTransformer();
            this.mSchemaLocation = schemaLocation;
        }
        catch (TransformerConfigurationException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }
}

