/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model.impl;

import com.sun.jbi.workflow.model.ModelElement;
import com.sun.jbi.workflow.model.ModelException;
import com.sun.jbi.workflow.model.Task;
import com.sun.jbi.workflow.model.Tasks;
import com.sun.jbi.workflow.model.impl.ModelElementImpl;
import com.sun.jbi.workflow.model.impl.TaskImpl;
import com.sun.jbi.workflow.model.impl.WSDLDefinitionImpl;
import com.sun.jbi.workflow.model.utl.Messages;
import com.sun.jbi.workflow.model.utl.ModelUtil;
import com.sun.jbi.workflow.model.xmlbeans.TImport;
import com.sun.jbi.workflow.model.xmlbeans.TTask;
import com.sun.jbi.workflow.model.xmlbeans.TTasks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksImpl
extends ModelElementImpl
implements Tasks {
    private static final Messages MESSAGES = Messages.getMessages(TasksImpl.class);
    private TTasks mTasks;
    private List mImportWSDLs;
    private List mTaskTypes;
    private String mBaseURI;
    private List mTaskList;
    private List<Task> taskList = new ArrayList<Task>();
    private Map<String, String> mNamespaceMap = null;

    public TasksImpl(TTasks tasks, String baseURI) {
        super((XmlObject)tasks, null);
        this.mTasks = tasks;
        this.mBaseURI = baseURI;
    }

    @Override
    public String getTargetNamespace() {
        return this.mTasks.getTargetNamespace();
    }

    @Override
    public List getImportWSDLs() throws ModelException {
        if (this.mImportWSDLs != null) {
            return this.mImportWSDLs;
        }
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            List imports = this.mTasks.getImportList();
            if (imports != null && imports.size() > 0) {
                this.mImportWSDLs = new ArrayList(imports.size());
                for (int i = 0; i < imports.size(); ++i) {
                    TImport importType = (TImport)imports.get(i);
                    Definition definition = wsdlReader.readWSDL(this.mBaseURI, importType.getLocation());
                    WSDLDefinitionImpl wsdlDef = new WSDLDefinitionImpl(definition);
                    this.mImportWSDLs.add(wsdlDef);
                }
            }
        }
        catch (Exception e) {
            throw new ModelException(MESSAGES.getString("TasksImpl.Can_not_parse_WSDL"), e);
        }
        return this.mImportWSDLs;
    }

    @Override
    public List<Task> getTasks() {
        if (this.taskList.size() == 0) {
            List tasks = this.mTasks.getTaskList();
            for (TTask tt : tasks) {
                TaskImpl t = new TaskImpl(tt, this);
                this.taskList.add(t);
            }
        }
        return this.taskList;
    }

    @Override
    public List<ModelElement> getChildren() {
        ArrayList<ModelElement> children = new ArrayList<ModelElement>();
        children.addAll(this.getTasks());
        return children;
    }

    @Override
    public Map<String, String> getTotalNamespaces() {
        if (this.mNamespaceMap != null) {
            return this.mNamespaceMap;
        }
        this.mNamespaceMap = new HashMap<String, String>();
        NamedNodeMap nodeMap = this.getDelegate().getDomNode().getAttributes();
        if (nodeMap.getLength() > 0) {
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Attr attribute = (Attr)Attr.class.cast(nodeMap.item(i));
                String name = attribute.getName();
                ModelUtil.addToNSMap(name, attribute.getValue(), this.mNamespaceMap);
            }
        }
        return this.mNamespaceMap;
    }
}

