/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model.impl;

import com.sun.jbi.workflow.model.Action;
import com.sun.jbi.workflow.model.Assignment;
import com.sun.jbi.workflow.model.DeadlineOrDuration;
import com.sun.jbi.workflow.model.Escalation;
import com.sun.jbi.workflow.model.Init;
import com.sun.jbi.workflow.model.LocalNotificationContainer;
import com.sun.jbi.workflow.model.ModelElement;
import com.sun.jbi.workflow.model.ModelException;
import com.sun.jbi.workflow.model.Notification;
import com.sun.jbi.workflow.model.PartnerLinkType;
import com.sun.jbi.workflow.model.Task;
import com.sun.jbi.workflow.model.Tasks;
import com.sun.jbi.workflow.model.Timeout;
import com.sun.jbi.workflow.model.impl.ActionImpl;
import com.sun.jbi.workflow.model.impl.AssignmentImpl;
import com.sun.jbi.workflow.model.impl.EscalationImpl;
import com.sun.jbi.workflow.model.impl.InitImpl;
import com.sun.jbi.workflow.model.impl.ModelElementImpl;
import com.sun.jbi.workflow.model.impl.NotificationImpl;
import com.sun.jbi.workflow.model.impl.TimeoutImpl;
import com.sun.jbi.workflow.model.impl.Util;
import com.sun.jbi.workflow.model.xmlbeans.TAction;
import com.sun.jbi.workflow.model.xmlbeans.TEscalation;
import com.sun.jbi.workflow.model.xmlbeans.TInit;
import com.sun.jbi.workflow.model.xmlbeans.TNotification;
import com.sun.jbi.workflow.model.xmlbeans.TTask;
import com.sun.jbi.workflow.model.xmlbeans.TTimeout;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathContextFactory;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskImpl
extends ModelElementImpl
implements Task {
    private TTask mTaskType;
    private Tasks mParent;
    private Operation mOperation;
    private PartnerLinkType mPartnerLinkType;
    private Init mInit;
    private Assignment mAssignment;
    private List<Timeout> mTimeoutList = new ArrayList<Timeout>();
    private List<Escalation> mEscalationList = new ArrayList<Escalation>();
    private List<Notification> mNotificationList = new ArrayList<Notification>();
    private List<Action> mActionList = new ArrayList<Action>();
    private JXPathContext mContext;

    public TaskImpl(TTask taskType, Tasks tasks) {
        super((XmlObject)taskType, tasks);
        this.mTaskType = taskType;
        this.mParent = tasks;
    }

    @Override
    public String getName() {
        return this.mTaskType.getName();
    }

    @Override
    public String getPartnerLink() {
        return this.mTaskType.getPartnerLink();
    }

    @Override
    public String getRole() {
        return this.mTaskType.getRole();
    }

    @Override
    public Operation getWSDLOperation() throws ModelException {
        if (this.mOperation != null) {
            return this.mOperation;
        }
        this.mOperation = Util.getWSDLOperation(this.mTaskType.getOperation(), this);
        return this.mOperation;
    }

    @Override
    public PartnerLinkType getWSDLPartnerLinkType() throws ModelException {
        if (this.mPartnerLinkType != null) {
            return this.mPartnerLinkType;
        }
        this.mPartnerLinkType = Util.getWSDLPartnerLinkType(this.mTaskType.getPartnerLinkType(), this);
        return this.mPartnerLinkType;
    }

    @Override
    public PortType getPortType() throws ModelException {
        PortType portType = Util.getPortType(this.mTaskType.getPartnerLinkType(), this.mTaskType.getRole(), this);
        return portType;
    }

    @Override
    public Assignment getTaskAssignment() {
        if (this.mAssignment == null && this.mTaskType.getAssignment() != null) {
            this.mAssignment = new AssignmentImpl(this.mTaskType.getAssignment(), (ModelElement)this);
        }
        return this.mAssignment;
    }

    @Override
    public List<Timeout> getTaskTimeouts() {
        if (this.mTimeoutList.size() == 0) {
            List tList = this.mTaskType.getTimeoutList();
            for (TTimeout tt : tList) {
                TimeoutImpl t = new TimeoutImpl(tt, this);
                this.mTimeoutList.add(t);
            }
        }
        return this.mTimeoutList;
    }

    @Override
    public List<Escalation> getTaskEscalations() {
        if (this.mEscalationList.size() == 0) {
            List eList = this.mTaskType.getEscalationList();
            for (TEscalation et : eList) {
                EscalationImpl e = new EscalationImpl(et, this);
                this.mEscalationList.add(e);
            }
        }
        return this.mEscalationList;
    }

    @Override
    public List<Notification> getTaskNotifications() {
        if (this.mNotificationList.size() == 0) {
            List eList = this.mTaskType.getNotificationList();
            for (TNotification et : eList) {
                NotificationImpl n = new NotificationImpl(et, (ModelElement)this);
                this.mNotificationList.add(n);
            }
        }
        return this.mNotificationList;
    }

    @Override
    public List<Action> getTaskActions() {
        if (this.mActionList.size() == 0) {
            List eList = this.mTaskType.getActionList();
            for (TAction act : eList) {
                ActionImpl action = new ActionImpl(act, (ModelElement)this);
                this.mActionList.add(action);
            }
        }
        return this.mActionList;
    }

    @Override
    public List<ModelElement> getChildren() {
        ArrayList<ModelElement> children = new ArrayList<ModelElement>();
        children.add(this.getTaskAssignment());
        children.addAll(this.getTaskTimeouts());
        children.addAll(this.getTaskEscalations());
        return children;
    }

    @Override
    public DeadlineOrDuration findDeadlineOrDuration(String xpath) {
        LocalNotificationContainer deadlineOrDuration = null;
        List<Timeout> timeouts = this.getTaskTimeouts();
        for (Timeout t : timeouts) {
            if (!xpath.equals(t.getXPathInfo().getXPath())) continue;
            deadlineOrDuration = t;
            return deadlineOrDuration;
        }
        List<Escalation> escalations = this.getTaskEscalations();
        for (Escalation e : escalations) {
            if (!xpath.equals(e.getXPathInfo().getXPath())) continue;
            deadlineOrDuration = e;
            return deadlineOrDuration;
        }
        return deadlineOrDuration;
    }

    @Override
    public JXPathContext getJXpathContext() {
        if (this.mContext == null) {
            this.mContext = JXPathContextFactory.newInstance().newContext(null, null);
        }
        return this.mContext;
    }

    @Override
    public void setJXpathContext(JXPathContext context) {
        this.mContext = context;
    }

    @Override
    public Init getInit() {
        if (this.mInit != null) {
            return this.mInit;
        }
        TInit init = this.mTaskType.getInit();
        this.mInit = new InitImpl(init, (ModelElement)this);
        return this.mInit;
    }

    @Override
    public Notification getNotification(QName notificationQName) {
        Notification notification = null;
        if (notificationQName != null) {
            List<Notification> nList = this.getTaskNotifications();
            for (Notification n : nList) {
                QName qName = n.getQName();
                if (!qName.equals(notificationQName)) continue;
                notification = n;
                break;
            }
        }
        return notification;
    }
}

