/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model;

import com.sun.jbi.workflow.model.ModelException;
import com.sun.jbi.workflow.model.Tasks;
import com.sun.jbi.workflow.model.impl.TasksImpl;
import com.sun.jbi.workflow.model.utl.Messages;
import com.sun.jbi.workflow.model.xmlbeans.TTasks;
import com.sun.jbi.workflow.model.xmlbeans.TasksDocument;
import java.io.File;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Node;

public class ModelFactory {
    private static final Messages MESSAGES = Messages.getMessages(ModelFactory.class);
    private static ModelFactory mInstance;

    private ModelFactory() {
    }

    public static ModelFactory getInstance() {
        if (mInstance == null) {
            mInstance = new ModelFactory();
        }
        return mInstance;
    }

    public Tasks getTasksModel(String fileName) throws ModelException {
        File wfFile = new File(fileName);
        TasksDocument tasksDoc = null;
        try {
            tasksDoc = TasksDocument.Factory.parse((File)new File(fileName));
        }
        catch (XmlException e) {
            throw new ModelException(MESSAGES.getString("ModelFactory.Parse_xmlException", fileName));
        }
        catch (IOException e) {
            throw new ModelException(MESSAGES.getString("ModelFactory.IOException", fileName));
        }
        TTasks tasks = tasksDoc.getTasks();
        TasksImpl modelTasks = new TasksImpl(tasks, wfFile.getParent());
        return modelTasks;
    }

    public Tasks getTasksModel(Node node) throws ModelException {
        TasksDocument tasksDoc = null;
        try {
            tasksDoc = TasksDocument.Factory.parse((Node)node);
        }
        catch (XmlException e) {
            throw new ModelException(MESSAGES.getString("ModelFactory.Parse_xmlException", node.getBaseURI()));
        }
        TTasks tasks = tasksDoc.getTasks();
        TasksImpl modelTasks = new TasksImpl(tasks, node.getBaseURI());
        return modelTasks;
    }
}

