/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Visitable;
import org.codehaus.xfire.service.Visitor;

public class FaultInfo
extends MessagePartContainer
implements Visitable {
    private String name;
    private QName messageName;
    private Class exceptionClass;

    FaultInfo(String name, OperationInfo operation) {
        super(operation);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        this.getOperation().removeFault(this.getName());
        this.name = name;
        this.getOperation().addFault(this);
    }

    public void accept(Visitor visitor) {
        visitor.startFault(this);
        Iterator iterator = this.getMessageParts().iterator();
        while (iterator.hasNext()) {
            MessagePartInfo messagePartInfo = (MessagePartInfo)iterator.next();
            messagePartInfo.accept(visitor);
        }
        visitor.endFault(this);
    }

    public Class getExceptionClass() {
        return this.exceptionClass;
    }

    public void setExceptionClass(Class exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public QName getMessageName() {
        return this.messageName;
    }

    public void setMessageName(QName messageName) {
        this.messageName = messageName;
    }
}

