/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ElseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class IfHandler
extends BlockParentHandler {
    public IfHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, "if", aAst, aParent);
    }

    public IndentLevel suggestedChildLevel(ExpressionHandler aChild) {
        if (aChild instanceof ElseHandler) {
            return this.getLevel();
        }
        return super.suggestedChildLevel(aChild);
    }

    protected IndentLevel getLevelImpl() {
        if (this.isIfAfterElse()) {
            return this.getParent().getLevel();
        }
        return super.getLevelImpl();
    }

    private boolean isIfAfterElse() {
        DetailAST parent = this.getMainAst().getParent();
        return parent.getType() == 92 && parent.getLineNo() == this.getMainAst().getLineNo();
    }

    protected void checkToplevelToken() {
        if (this.isIfAfterElse()) {
            return;
        }
        super.checkToplevelToken();
    }

    private void checkCondExpr() {
        DetailAST condAst = (DetailAST)this.getMainAst().findFirstToken(76).getNextSibling();
        IndentLevel expected = new IndentLevel(this.getLevel(), this.getBasicOffset());
        this.checkExpressionSubtree(condAst, expected, false, false);
    }

    public void checkIndentation() {
        super.checkIndentation();
        this.checkCondExpr();
    }
}

