/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.util.Vector;
import org.netbeans.apitest.ClassCollection;
import org.netbeans.apitest.ClassFinder;
import org.netbeans.apitest.SignatureClass;
import org.netbeans.apitest.TableOfClass;

final class ClassSorter {
    private Vector regularClasses = new Vector();
    private Vector nestedClasses = new Vector();
    private Vector classes;
    private boolean isReflectUsed;
    private ClassFinder loader;
    public ClassCollection errors = new ClassCollection();

    public ClassSorter(Vector classes, boolean isReflectUsed, ClassFinder loader) {
        this.classes = classes;
        this.isReflectUsed = isReflectUsed;
        this.loader = loader;
    }

    public static void sortVector(Vector h) {
        for (int j = 0; j < h.size(); ++j) {
            int pos = j;
            String min = (String)h.elementAt(j);
            for (int i = j; i < h.size(); ++i) {
                String temp = (String)h.elementAt(i);
                if (temp.compareTo(min) >= 0) continue;
                pos = i;
                min = (String)h.elementAt(i);
            }
            h.setElementAt(h.elementAt(j), pos);
            h.setElementAt(min, j);
        }
    }

    void foundNested(SignatureClass c) {
        if (c == null) {
            return;
        }
        String name = c.getName();
        if (name.indexOf(36) < 0) {
            if (this.regularClasses.contains(name)) {
                return;
            }
            this.regularClasses.addElement(name);
        } else {
            if (this.nestedClasses.contains(name)) {
                return;
            }
            this.nestedClasses.addElement(name);
        }
        this.foundNested(c.getSuperclass());
        SignatureClass[] intf = c.getInterfaces();
        for (int i = 0; i < intf.length; ++i) {
            this.foundNested(intf[i]);
        }
        if (this.isReflectUsed) {
            SignatureClass[] nestCl = c.getDeclaredClasses();
            for (int i = 0; i < nestCl.length; ++i) {
                this.foundNested(nestCl[i]);
            }
        } else {
            Vector h = TableOfClass.getDeclaredNestedClasses(name);
            for (int i = 0; i < h.size(); ++i) {
                try {
                    String clName = (String)h.elementAt(i);
                    SignatureClass nestCl = this.loader.loadClass(clName);
                    this.foundNested(nestCl);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.errors.addUniqueElement(name, "Class not found: " + h.elementAt(i));
                    continue;
                }
                catch (LinkageError er) {
                    this.errors.addUniqueElement(name, "Class not linked: " + h.elementAt(i));
                }
            }
        }
    }

    public Vector getSortedClasses(ClassCollection errors) {
        int i;
        this.errors = errors;
        for (i = 0; i < this.classes.size(); ++i) {
            String name = (String)this.classes.elementAt(i);
            try {
                SignatureClass c = this.loader.loadClass(name);
                this.foundNested(c);
                continue;
            }
            catch (ClassNotFoundException e) {
                errors.addUniqueElement(name, "Class not found: " + name);
                continue;
            }
            catch (LinkageError er) {
                errors.addUniqueElement(name, "Class not linked: " + name);
            }
        }
        ClassSorter.sortVector(this.nestedClasses);
        ClassSorter.sortVector(this.regularClasses);
        Vector retVal = this.nestedClasses;
        for (i = 0; i < this.regularClasses.size(); ++i) {
            if (!this.classes.contains(this.regularClasses.elementAt(i))) continue;
            retVal.addElement(this.regularClasses.elementAt(i));
        }
        return retVal;
    }

    public boolean isAccessible(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf(36) >= 0) {
            return this.nestedClasses.contains(name);
        }
        return this.regularClasses.contains(name);
    }
}

