/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmAuthPair;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmPasswordLcd;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmPrivPair;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;

class SnmpUsmSecureUserImpl
implements SnmpUsmSecureUser {
    private String dbgTag = "SnmpUsmSecureUserImpl";
    String name = null;
    String securityName = null;
    String password = null;
    SnmpUsmAuthPair auth = null;
    SnmpUsmPrivPair priv = null;
    SnmpEngineId engineId = null;
    String CONF_SEPARATOR = ",";
    int storageType = 1;
    SnmpUsmLcd lcd = null;
    String privKey = null;
    String authKey = null;
    String strEngineId = null;
    String privProtocol = null;
    String authProtocol = null;
    boolean template = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmSecureUserImpl");

    SnmpUsmSecureUserImpl(SnmpUsmLcd snmpUsmLcd, SnmpEngineId snmpEngineId, String string) {
        this.init(snmpUsmLcd, snmpEngineId, string);
        this.securityName = string;
        this.strEngineId = snmpEngineId.toString();
    }

    SnmpUsmSecureUserImpl(SnmpUsmLcd snmpUsmLcd, SnmpEngineId snmpEngineId, String string, String string2, String string3, SnmpUsmAuthAlgorithm snmpUsmAuthAlgorithm, String string4, byte[] byArray, String string5, SnmpUsmPrivAlgorithm snmpUsmPrivAlgorithm, String string6, byte[] byArray2, String string7, int n, boolean bl) {
        this.init(snmpUsmLcd, snmpEngineId, string2);
        this.strEngineId = string;
        this.securityName = string3;
        this.auth.algo = snmpUsmAuthAlgorithm;
        this.authProtocol = string4;
        this.auth.key = byArray;
        this.priv.algo = snmpUsmPrivAlgorithm;
        this.privProtocol = string6;
        this.priv.key = byArray2;
        this.authKey = string5;
        this.privKey = string7;
        this.storageType = n;
        this.template = bl;
    }

    public void updateConfiguration() {
        ((SnmpUsmPasswordLcd)this.lcd).flushFile();
    }

    public int getSecurityLevel() {
        int n = 0;
        if (this.auth.algo != null && this.auth.key != null) {
            n |= 1;
        }
        if (this.priv.algo != null && this.priv.key != null) {
            n |= 2;
        }
        return n;
    }

    public byte[] getAuthDelta(byte[] byArray, byte[] byArray2) {
        if (this.auth.algo == null) {
            return null;
        }
        return this.auth.algo.calculateAuthDelta(this.auth.key, byArray, byArray2);
    }

    public byte[] getPrivDelta(byte[] byArray, byte[] byArray2) {
        if (this.auth.algo == null || this.priv.algo == null) {
            return null;
        }
        return this.auth.algo.calculatePrivDelta(this.priv.key, byArray, byArray2, this.priv.algo.getDeltaSize());
    }

    public void setAuthKeyChange(byte[] byArray) {
        if (this.auth.algo == null) {
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setAuthKeyChange", " auth algo : " + this.auth.algo);
        }
        this.auth.key = this.auth.algo.calculateNewAuthKey(this.auth.key, byArray);
        this.authKey = SnmpTools.binary2ascii(this.auth.key);
    }

    public void setPrivKeyChange(byte[] byArray) {
        if (this.priv.algo == null) {
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setPrivKeyChange", " priv algo : " + this.priv.algo);
        }
        this.priv.key = this.auth.algo.calculateNewPrivKey(this.priv.key, byArray, this.priv.algo.getDeltaSize());
        this.privKey = SnmpTools.binary2ascii(this.priv.key);
    }

    public void setAuthAlgorithm(String string) {
        if (string.equals("usmNoAuthProtocol") || string.equals("1.3.6.1.6.3.10.1.1.1")) {
            this.authProtocol = "usmNoAuthProtocol";
            this.auth.algo = null;
            this.auth.key = null;
            this.authKey = null;
            return;
        }
        this.auth.algo = (SnmpUsmAuthAlgorithm)this.lcd.getAlgorithmManager().getAlgorithm(string);
    }

    public void setPrivAlgorithm(String string) {
        if (string.equals("usmNoPrivProtocol") || string.equals("1.3.6.1.6.3.10.1.2.1")) {
            this.privProtocol = "usmNoPrivProtocol";
            this.priv.algo = null;
            this.priv.key = null;
            this.privKey = null;
            return;
        }
        this.priv.algo = (SnmpUsmPrivAlgorithm)this.lcd.getAlgorithmManager().getAlgorithm(string);
    }

    public String getName() {
        return this.name;
    }

    public void setSecurityName(String string) {
        this.securityName = string;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public SnmpEngineId getEngineId() {
        return this.engineId;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int n) {
        this.storageType = n;
    }

    public SnmpUsmAuthPair getAuthPair() {
        return this.auth;
    }

    public SnmpUsmPrivPair getPrivPair() {
        return this.priv;
    }

    public void cloneAuthPair(SnmpUsmAuthPair snmpUsmAuthPair) {
        this.auth.algo = snmpUsmAuthPair.algo;
        if (this.auth.algo != null) {
            this.authProtocol = this.auth.algo.getAlgorithm();
        }
        if (snmpUsmAuthPair.key != null) {
            byte[] byArray = new byte[snmpUsmAuthPair.key.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = snmpUsmAuthPair.key[i];
            }
            this.auth.key = byArray;
            this.authKey = SnmpTools.binary2ascii(this.auth.key);
        }
    }

    public void clonePrivPair(SnmpUsmPrivPair snmpUsmPrivPair) {
        this.priv.algo = snmpUsmPrivPair.algo;
        if (this.priv.algo != null) {
            this.privProtocol = this.priv.algo.getAlgorithm();
        }
        if (snmpUsmPrivPair.key != null) {
            byte[] byArray = new byte[snmpUsmPrivPair.key.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = snmpUsmPrivPair.key[i];
            }
            this.priv.key = byArray;
            this.privKey = SnmpTools.binary2ascii(this.priv.key);
        }
    }

    byte[] getAuthKey() {
        return this.auth.key;
    }

    byte[] getPrivKey() {
        return this.priv.key;
    }

    void setPrivKey(byte[] byArray) {
        this.priv.key = byArray;
    }

    void setAuthKey(byte[] byArray) {
        this.auth.key = byArray;
    }

    String getConf() {
        String string = this.authKey == null ? this.CONF_SEPARATOR : this.authKey + this.CONF_SEPARATOR;
        String string2 = this.privKey == null ? this.CONF_SEPARATOR : this.privKey + this.CONF_SEPARATOR;
        String string3 = this.securityName == null ? this.CONF_SEPARATOR : this.securityName + this.CONF_SEPARATOR;
        String string4 = this.storageType + this.CONF_SEPARATOR;
        String string5 = this.authProtocol == null ? this.CONF_SEPARATOR : this.authProtocol + this.CONF_SEPARATOR;
        String string6 = this.privProtocol == null ? this.CONF_SEPARATOR : this.privProtocol + this.CONF_SEPARATOR;
        String string7 = null;
        String string8 = this.strEngineId + this.CONF_SEPARATOR + this.name + this.CONF_SEPARATOR + string3 + string5 + string + string6 + string2 + string4;
        string7 = this.template ? string8 + "true" : string8;
        return string7;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplateStatus(boolean bl) {
        this.template = bl;
    }

    private void init(SnmpUsmLcd snmpUsmLcd, SnmpEngineId snmpEngineId, String string) {
        this.engineId = snmpEngineId;
        this.name = string;
        this.lcd = snmpUsmLcd;
        this.auth = new SnmpUsmAuthPair();
        this.priv = new SnmpUsmPrivPair();
    }
}

