/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpDecryptedPdu;
import com.sun.management.internal.snmp.SnmpEncryptionPair;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.usm.SnmpUserSecurityModel;
import com.sun.management.snmp.usm.SnmpUsmEngineIdException;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmPrivException;
import com.sun.management.snmp.usm.SnmpUsmPrivPair;
import com.sun.management.snmp.usm.SnmpUsmSecurityCache;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.management.snmp.usm.SnmpUsmUserNameException;

class SnmpUsmPrivModule {
    SnmpUserSecurityModel model = null;
    SnmpUsmLcd lcd = null;
    SnmpUsmExceptionGenerator genExp = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmPrivModule");
    String dbgTag = "SnmpUsmPrivModule";

    SnmpUsmPrivModule(SnmpUserSecurityModel snmpUserSecurityModel, SnmpUsmLcd snmpUsmLcd, SnmpUsmExceptionGenerator snmpUsmExceptionGenerator) {
        this.model = snmpUserSecurityModel;
        this.lcd = snmpUsmLcd;
        this.genExp = snmpUsmExceptionGenerator;
    }

    SnmpDecryptedPdu decrypt(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, int n, SnmpUsmSecurityParameters snmpUsmSecurityParameters, SnmpUsmSecurityCache snmpUsmSecurityCache, byte[] byArray, byte by) throws SnmpSecurityException, SnmpStatusException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.decrypt(snmpUsmSecurityCache, snmpUsmSecurityParameters, byArray);
            return snmpMsgProcessingSubSystem.decode(n, byArray2);
        }
        catch (SnmpUsmPrivException snmpUsmPrivException) {
            if (logger.finestOn()) {
                logger.finest("decrypt", snmpUsmPrivException.toString());
            }
            this.genExp.genDecryptionException(by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmPrivAlgorithmException snmpUsmPrivAlgorithmException) {
            if (logger.finestOn()) {
                logger.finest("decrypt", snmpUsmPrivAlgorithmException.toString());
            }
            this.genExp.genSecurityLevelException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmUserNameException snmpUsmUserNameException) {
            if (logger.finestOn()) {
                logger.finest("decrypt", snmpUsmUserNameException.toString());
            }
            this.genExp.genUserNameException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmEngineIdException snmpUsmEngineIdException) {
            this.genExp.genEngineIdException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmException snmpUsmException) {
            if (logger.finestOn()) {
                logger.finest("decrypt", snmpUsmException.toString());
            }
            this.genExp.genDecryptionException(by, snmpUsmSecurityParameters);
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (logger.finestOn()) {
                logger.finest("decrypt", snmpUnknownMsgProcModelException.toString());
            }
            this.genExp.genDecryptionException(by, snmpUsmSecurityParameters);
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("decrypt", exception.toString());
            }
            this.genExp.genDecryptionException(by, snmpUsmSecurityParameters);
        }
        return null;
    }

    private byte[] decrypt(SnmpUsmSecurityCache snmpUsmSecurityCache, SnmpUsmSecurityParameters snmpUsmSecurityParameters, byte[] byArray) throws SnmpUsmException {
        SnmpUsmPrivPair snmpUsmPrivPair = null;
        if (logger.finerOn()) {
            logger.finer("decrypt", " userName : " + snmpUsmSecurityParameters.getUserName());
        }
        snmpUsmPrivPair = this.lcd.getUserPrivPair(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getUserName());
        if (snmpUsmSecurityCache != null) {
            snmpUsmSecurityCache.priv = snmpUsmPrivPair;
        }
        SnmpEncryptionPair snmpEncryptionPair = new SnmpEncryptionPair();
        snmpEncryptionPair.encryptedData = byArray;
        snmpEncryptionPair.parameters = snmpUsmSecurityParameters.getPrivParameters();
        byte[] byArray2 = snmpUsmPrivPair.algo.decrypt(snmpUsmPrivPair.key, snmpEncryptionPair);
        return byArray2;
    }

    byte[] encrypt(SnmpUsmSecurityCache snmpUsmSecurityCache, SnmpUsmSecurityParameters snmpUsmSecurityParameters, byte[] byArray, int n) throws SnmpUsmException {
        SnmpUsmPrivPair snmpUsmPrivPair = null;
        if (logger.finerOn()) {
            logger.finer("encrypt", " userName : " + snmpUsmSecurityParameters.getUserName());
        }
        if (snmpUsmSecurityCache != null) {
            if (snmpUsmSecurityCache.priv != null) {
                snmpUsmPrivPair = snmpUsmSecurityCache.priv;
            } else {
                snmpUsmSecurityCache.priv = snmpUsmPrivPair = this.lcd.getUserPrivPair(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getUserName());
            }
        } else {
            snmpUsmPrivPair = this.lcd.getUserPrivPair(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getUserName());
        }
        SnmpEncryptionPair snmpEncryptionPair = snmpUsmPrivPair.algo.encrypt(snmpUsmPrivPair.key, byArray, n);
        snmpUsmSecurityParameters.setPrivParameters(snmpEncryptionPair.parameters);
        return snmpEncryptionPair.encryptedData;
    }
}

