/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;
import java.net.InetAddress;
import java.util.Vector;

class SendQ
extends Vector {
    private static final long serialVersionUID = 7156215046287757465L;
    final long sendQ_pollMargin = 0L;
    boolean isBeingDestroyed = false;

    SendQ(int n, int n2) {
        super(n, n2);
    }

    public synchronized String printAllRequest(long l) {
        if (this.isEmpty()) {
            return "------- SendQ empty.......";
        }
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer("\n------------------------ Requests in SendQ -> " + n);
        for (int i = 0; i < n; ++i) {
            SnmpRequest snmpRequest = this.getRequestAt(i);
            stringBuffer.append("\n" + i + ". (" + snmpRequest.toString() + " RemainingTimeToSend = " + snmpRequest.timeRemainingForAction(l) + "  ) ................................\n");
        }
        return stringBuffer.toString();
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized void addRequest(SnmpRequest snmpRequest) {
        int n;
        long l = snmpRequest.getAbsNextPollTime();
        for (n = this.size(); n > 0 && l >= this.getRequestAt(n - 1).getAbsNextPollTime(); --n) {
        }
        if (n == this.size()) {
            this.addElement(snmpRequest);
            this.notifyClients();
        } else {
            this.insertElementAt(snmpRequest, n);
        }
    }

    public synchronized SnmpRequest getOutstandingRequest() {
        this.waitUntilReady();
        SnmpRequest snmpRequest = (SnmpRequest)this.lastElement();
        --this.elementCount;
        return snmpRequest;
    }

    synchronized void introduceSleep(long l) {
        long l2 = System.currentTimeMillis();
        while (true) {
            try {
                do {
                    this.wait(l);
                } while (System.currentTimeMillis() - l2 < l);
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long l = 0L;
            if (!this.isEmpty()) {
                long l2 = System.currentTimeMillis();
                SnmpRequest snmpRequest = (SnmpRequest)this.lastElement();
                l = snmpRequest.getAbsNextPollTime() - l2;
                if (l <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l);
        }
        return false;
    }

    public synchronized Vector getAllOutstandingRequest(long l) {
        Vector<SnmpRequest> vector = new Vector<SnmpRequest>();
        while (this.waitUntilReady()) {
            SnmpRequest snmpRequest;
            long l2 = System.currentTimeMillis() + l;
            for (int i = this.size(); i > 0 && (snmpRequest = this.getRequestAt(i - 1)).getAbsNextPollTime() <= l2; --i) {
                vector.addElement(snmpRequest);
            }
            if (vector.isEmpty()) continue;
            this.elementCount -= vector.size();
            return vector;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long l) {
        if (l == 0L && !this.isEmpty() && SnmpQManager.logger.finestOn()) {
            SnmpQManager.logger.finest("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on newq permenantly. But size = " + this.size());
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SnmpRequest getRequestAt(int n) {
        return (SnmpRequest)this.elementAt(n);
    }

    public synchronized SnmpRequest removeRequest(long l) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SnmpRequest snmpRequest = this.getRequestAt(i);
            if (l != (long)snmpRequest.getRequestId()) continue;
            this.removeElementAt(i);
            return snmpRequest;
        }
        return null;
    }

    public synchronized SnmpPduFactory findPduFactory(InetAddress inetAddress, int n) {
        SnmpPduFactory snmpPduFactory = null;
        int n2 = this.size();
        for (int i = 0; i < n2 && snmpPduFactory == null; ++i) {
            SnmpRequest snmpRequest = this.getRequestAt(i);
            snmpPduFactory = snmpRequest.getSnmpSession().getPduFactory();
        }
        return snmpPduFactory;
    }
}

