/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.IPAcl.AclEntryImpl;
import com.sun.management.snmp.IPAcl.AclImpl;
import com.sun.management.snmp.IPAcl.JDMAccess;
import com.sun.management.snmp.IPAcl.JDMAclItem;
import com.sun.management.snmp.IPAcl.JDMCommunities;
import com.sun.management.snmp.IPAcl.JDMHost;
import com.sun.management.snmp.IPAcl.JDMHostInform;
import com.sun.management.snmp.IPAcl.JDMHostTrap;
import com.sun.management.snmp.IPAcl.JDMInformCommunity;
import com.sun.management.snmp.IPAcl.JDMInformInterestedHost;
import com.sun.management.snmp.IPAcl.JDMInformItem;
import com.sun.management.snmp.IPAcl.JDMManagers;
import com.sun.management.snmp.IPAcl.JDMTrapCommunity;
import com.sun.management.snmp.IPAcl.JDMTrapInterestedHost;
import com.sun.management.snmp.IPAcl.JDMTrapItem;
import com.sun.management.snmp.IPAcl.Parser;
import com.sun.management.snmp.IPAcl.PrincipalImpl;
import com.sun.management.snmp.IPAcl.SimpleNode;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.util.Hashtable;
import java.util.Vector;

abstract class Host
extends SimpleNode
implements Serializable {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "Host");
    String dbgTag = "Host";

    public Host(int n) {
        super(n);
    }

    public Host(Parser parser, int n) {
        super(parser, n);
    }

    protected abstract PrincipalImpl createAssociatedPrincipal() throws UnknownHostException;

    protected abstract String getHname();

    public void buildAclEntries(PrincipalImpl principalImpl, AclImpl aclImpl) {
        PrincipalImpl principalImpl2 = null;
        try {
            principalImpl2 = this.createAssociatedPrincipal();
        }
        catch (UnknownHostException unknownHostException) {
            if (logger.finestOn()) {
                logger.finest("buildAclEntries", "Cannot create ACL entry for " + unknownHostException.getMessage());
            }
            throw new IllegalArgumentException("Cannot create ACL entry for " + unknownHostException.getMessage());
        }
        AclEntryImpl aclEntryImpl = null;
        try {
            aclEntryImpl = new AclEntryImpl(principalImpl2);
            this.registerPermission(aclEntryImpl);
            aclImpl.addEntry(principalImpl, aclEntryImpl);
        }
        catch (UnknownHostException unknownHostException) {
            if (logger.finestOn()) {
                logger.finest("buildAclEntries", "Cannot create ACL entry for " + unknownHostException.getMessage());
            }
            return;
        }
        catch (NotOwnerException notOwnerException) {
            if (logger.finestOn()) {
                logger.finest("buildAclEntries", "Not owner of ACL " + notOwnerException.getMessage());
            }
            return;
        }
    }

    private void registerPermission(AclEntryImpl aclEntryImpl) {
        JDMHost jDMHost = (JDMHost)this.jjtGetParent();
        JDMManagers jDMManagers = (JDMManagers)jDMHost.jjtGetParent();
        JDMAclItem jDMAclItem = (JDMAclItem)jDMManagers.jjtGetParent();
        JDMAccess jDMAccess = jDMAclItem.getAccess();
        jDMAccess.putPermission(aclEntryImpl);
        JDMCommunities jDMCommunities = jDMAclItem.getCommunities();
        jDMCommunities.buildCommunities(aclEntryImpl);
    }

    public void buildTrapEntries(Hashtable hashtable) {
        JDMHostTrap jDMHostTrap = (JDMHostTrap)this.jjtGetParent();
        JDMTrapInterestedHost jDMTrapInterestedHost = (JDMTrapInterestedHost)jDMHostTrap.jjtGetParent();
        JDMTrapItem jDMTrapItem = (JDMTrapItem)jDMTrapInterestedHost.jjtGetParent();
        JDMTrapCommunity jDMTrapCommunity = jDMTrapItem.getCommunity();
        String string = jDMTrapCommunity.getCommunity();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException unknownHostException) {
            if (logger.finestOn()) {
                logger.finest("buildTrapEntries", "Cannot create TRAP entry for " + unknownHostException.getMessage());
            }
            return;
        }
        Vector vector = null;
        if (hashtable.containsKey(inetAddress)) {
            vector = (Vector)hashtable.get(inetAddress);
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
        } else {
            vector = new Vector();
            vector.addElement(string);
            hashtable.put(inetAddress, vector);
        }
    }

    public void buildInformEntries(Hashtable hashtable) {
        JDMHostInform jDMHostInform = (JDMHostInform)this.jjtGetParent();
        JDMInformInterestedHost jDMInformInterestedHost = (JDMInformInterestedHost)jDMHostInform.jjtGetParent();
        JDMInformItem jDMInformItem = (JDMInformItem)jDMInformInterestedHost.jjtGetParent();
        JDMInformCommunity jDMInformCommunity = jDMInformItem.getCommunity();
        String string = jDMInformCommunity.getCommunity();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException unknownHostException) {
            if (logger.finestOn()) {
                logger.finest("buildInformEntries", "Cannot create INFORM entry for " + unknownHostException.getMessage());
            }
            return;
        }
        Vector vector = null;
        if (hashtable.containsKey(inetAddress)) {
            vector = (Vector)hashtable.get(inetAddress);
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
        } else {
            vector = new Vector();
            vector.addElement(string);
            hashtable.put(inetAddress, vector);
        }
    }
}

