/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.ClientHandler;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpMibContextName;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpSubBulkRequestHandler;
import com.sun.management.comm.SnmpSubNextRequestHandler;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.internal.snmp.SnmpAccessControlSubSystem;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpAckPdu;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpNull;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduBulkType;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownAccContrModelException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpRequestForwarder;
import com.sun.management.snmp.agent.SnmpUserDataFactory;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class SnmpV3RequestHandler
extends ClientHandler
implements SnmpDefinitions {
    private transient DatagramSocket socket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = null;
    private transient Hashtable contexts = null;
    private transient Hashtable forwarders = null;
    private transient Hashtable subs = null;
    private transient SnmpMibTree root;
    private transient Vector currentMibs = null;
    private transient SnmpMibTree currentRoot = null;
    private transient Object ipacl = null;
    private transient SnmpPduFactory pduFactory = null;
    private transient SnmpUserDataFactory userDataFactory = null;
    private transient SnmpEngineImpl engine = null;
    private transient SnmpMsgProcessingSubSystem msgProcSubSys = null;
    private transient SnmpAccessControlSubSystem accessSubSys = null;
    private transient SnmpV3AdaptorServer adaptor = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpStatusException noSuchNameException = new SnmpStatusException(2);

    public SnmpV3RequestHandler(SnmpV3AdaptorServer snmpV3AdaptorServer, SnmpEngine snmpEngine, int n, DatagramSocket datagramSocket, DatagramPacket datagramPacket, Hashtable hashtable, Hashtable hashtable2, SnmpMibTree snmpMibTree, Vector vector, Object object, SnmpPduFactory snmpPduFactory, SnmpUserDataFactory snmpUserDataFactory, MBeanServer mBeanServer, ObjectName objectName) {
        super(snmpV3AdaptorServer, n, mBeanServer, objectName);
        this.adaptor = snmpV3AdaptorServer;
        this.engine = (SnmpEngineImpl)snmpEngine;
        this.msgProcSubSys = this.engine.getMsgProcessingSubSystem();
        this.accessSubSys = this.engine.getAccessControlSubSystem();
        this.contexts = hashtable;
        this.forwarders = hashtable2;
        this.socket = datagramSocket;
        this.packet = datagramPacket;
        this.root = snmpMibTree;
        this.mibs = (Vector)vector.clone();
        this.ipacl = object;
        this.pduFactory = snmpPduFactory;
        this.userDataFactory = snmpUserDataFactory;
        if (this.logger.finestOn()) {
            this.logger.finest("SnmpV3RequestHandler", "userDataFactory : " + this.userDataFactory);
        }
    }

    public void doRun() {
        block11: {
            if (this.logger.finerOn()) {
                this.logger.finer("doRun", "Packet received:\n" + SnmpMsg.dumpHexBuffer(this.packet.getData(), 0, this.packet.getLength()));
            }
            DatagramPacket datagramPacket = this.makeResponsePacket(this.packet);
            if (this.logger.finerOn() && datagramPacket != null) {
                this.logger.finer("doRun", "Packet to be sent:\n" + SnmpMsg.dumpHexBuffer(datagramPacket.getData(), 0, datagramPacket.getLength()));
            }
            if (datagramPacket != null) {
                try {
                    this.socket.send(datagramPacket);
                }
                catch (SocketException socketException) {
                    if (this.logger.finestOn()) {
                        if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                            this.logger.finest("doRun", "interrupted");
                        } else {
                            this.logger.finest("doRun", "i/o exception");
                            this.logger.finest("doRun", socketException);
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "interrupted");
                    }
                }
                catch (Exception exception) {
                    if (!this.logger.finestOn()) break block11;
                    this.logger.finest("doRun", "failure when sending response");
                    this.logger.finest("doRun", exception);
                }
            }
        }
    }

    private SnmpRequestForwarder handleContextEngineId(SnmpIncomingRequest snmpIncomingRequest) {
        SnmpEngineId snmpEngineId = SnmpEngineId.createEngineId(snmpIncomingRequest.getContextEngineId());
        SnmpRequestForwarder snmpRequestForwarder = null;
        if (!this.engine.getEngineId().equals(snmpEngineId)) {
            if (this.logger.finerOn()) {
                this.logger.finer("handleContextEngineId", " The received contextEngineId is UNKNOWN:[" + snmpEngineId + "]. Forward to registered proxy.");
            }
            if (snmpEngineId != null) {
                snmpRequestForwarder = (SnmpRequestForwarder)this.forwarders.get(snmpEngineId.toString());
            }
            if (snmpRequestForwarder == null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("handleContextEngineId", " The received contextEngineId is not handled:[" + snmpEngineId + "]");
                }
                snmpIncomingRequest.noResponse();
            }
        }
        return snmpRequestForwarder;
    }

    private void handleContextName(SnmpIncomingRequest snmpIncomingRequest) {
        if (snmpIncomingRequest.getContextName() != null) {
            String string = new String(snmpIncomingRequest.getContextName());
            if (snmpIncomingRequest.getContextName().length != 0 && !string.equals("default")) {
                SnmpMibContextName snmpMibContextName;
                if (this.logger.finerOn()) {
                    this.logger.finer("handleContextName", " The received contextName is :[" + string + "]");
                }
                if ((snmpMibContextName = (SnmpMibContextName)this.contexts.get(string)) != null) {
                    this.currentRoot = snmpMibContextName.root;
                    this.currentMibs = snmpMibContextName.mibs;
                } else {
                    if (this.logger.finerOn()) {
                        this.logger.finer("handleContextName", " The received contextName is UNKNOWN:[" + string + "]");
                    }
                    this.adaptor.incSnmpUnknownContexts(1);
                    snmpIncomingRequest.noResponse();
                }
            } else {
                this.currentRoot = this.root;
                this.currentMibs = this.mibs;
            }
        } else {
            this.currentRoot = this.root;
            this.currentMibs = this.mibs;
        }
    }

    private DatagramPacket makeResponsePacket(DatagramPacket datagramPacket) {
        DatagramPacket datagramPacket2 = null;
        SnmpIncomingRequest snmpIncomingRequest = null;
        int n = 0;
        try {
            n = SnmpMsg.getProtocolVersion(datagramPacket.getData());
            snmpIncomingRequest = this.msgProcSubSys.getIncomingRequest(n, this.pduFactory);
            snmpIncomingRequest.decodeMessage(datagramPacket.getData(), datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort());
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "Unknown Msg Processing Model:" + n);
                this.logger.finest("makeResponsePacket", snmpUnknownMsgProcModelException);
            }
            this.adaptor.incSnmpInBadVersions(1);
            this.adaptor.incSnmpInvalidMsgs(1);
            return null;
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "Unknown Security Model:" + n);
                this.logger.finest("makeResponsePacket", snmpUnknownSecModelException);
            }
            this.adaptor.incSnmpUnknownSecurityModels(1);
            return null;
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "Bad Security Level:" + n);
                this.logger.finest("makeResponsePacket", snmpBadSecurityLevelException);
            }
            this.adaptor.incSnmpInvalidMsgs(1);
            return null;
        }
        catch (SnmpStatusException snmpStatusException) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "packet decoding failed");
            }
            this.adaptor.incSnmpInASNParseErrs(1);
            return null;
        }
        if (snmpIncomingRequest.isReport()) {
            try {
                datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponsePacket", "response message is too big");
                }
                try {
                    this.newTooBigMessage(snmpIncomingRequest);
                    datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
            return datagramPacket2;
        }
        if (snmpIncomingRequest.isResponse()) {
            SnmpRequestForwarder snmpRequestForwarder = this.handleContextEngineId(snmpIncomingRequest);
            if (snmpRequestForwarder != null) {
                this.makeResponseMessage(snmpIncomingRequest, snmpRequestForwarder);
            } else if (snmpIncomingRequest.isResponse()) {
                this.handleContextName(snmpIncomingRequest);
                if (snmpIncomingRequest.isResponse()) {
                    this.subs = new Hashtable(this.currentMibs.size());
                    this.makeResponseMessage(snmpIncomingRequest, null);
                }
            }
        }
        if (snmpIncomingRequest.isResponse()) {
            try {
                datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponsePacket", "response message is too big");
                }
                try {
                    this.newTooBigMessage(snmpIncomingRequest);
                    datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpTooBigException snmpTooBigException3) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
        }
        return datagramPacket2;
    }

    private void makeResponseMessage(SnmpIncomingRequest snmpIncomingRequest, SnmpRequestForwarder snmpRequestForwarder) {
        Object object;
        SnmpPdu snmpPdu;
        block29: {
            snmpPdu = null;
            object = null;
            try {
                snmpPdu = snmpIncomingRequest.decodeSnmpPdu();
                if (snmpPdu != null && this.userDataFactory != null) {
                    object = this.userDataFactory.allocateUserData(snmpPdu);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpPdu = null;
                this.adaptor.incSnmpInASNParseErrs(1);
                if (snmpStatusException.getStatus() == 243) {
                    this.adaptor.incSnmpInBadVersions(1);
                }
                if (!this.logger.finestOn()) break block29;
                this.logger.finest("makeResponseMessage", "message decoding failed");
            }
        }
        SnmpPdu snmpPdu2 = null;
        if (snmpPdu != null) {
            snmpPdu2 = this.makeResponsePdu(snmpIncomingRequest, snmpPdu, object, snmpRequestForwarder);
            try {
                if (this.userDataFactory != null) {
                    this.userDataFactory.releaseUserData(object, snmpPdu2);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpPdu2 = null;
            }
        }
        if (snmpPdu2 != null) {
            try {
                snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, this.packet.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpIncomingRequest.noResponse();
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponseMessage", "failure when encoding the response message");
                    this.logger.finest("makeResponseMessage", snmpStatusException);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponseMessage", "response message is too big");
                }
                try {
                    if (this.packet.getData().length <= 32) {
                        throw snmpTooBigException;
                    }
                    int n = snmpTooBigException.getVarBindCount();
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponseMessage", "fail on element" + n);
                    }
                    int n2 = 0;
                    while (true) {
                        try {
                            snmpPdu2 = this.reduceResponsePdu(snmpPdu, snmpPdu2, n);
                            snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, this.packet.getData().length - 32);
                        }
                        catch (SnmpTooBigException snmpTooBigException2) {
                            if (this.logger.finestOn()) {
                                this.logger.finest("makeResponseMessage", "response message is still too big");
                            }
                            n2 = n;
                            n = snmpTooBigException2.getVarBindCount();
                            if (!this.logger.finestOn()) continue;
                            this.logger.finest("makeResponseMessage", "fail on element" + n);
                            if (n != n2) continue;
                            throw snmpTooBigException2;
                        }
                        break;
                    }
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpIncomingRequest.noResponse();
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponseMessage", "failure when encoding the response message");
                        this.logger.finest("makeResponseMessage", snmpStatusException);
                    }
                }
                catch (SnmpTooBigException snmpTooBigException3) {
                    try {
                        snmpPdu2 = this.newTooBigPdu(snmpPdu);
                        snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, this.packet.getData().length);
                    }
                    catch (SnmpTooBigException snmpTooBigException4) {
                        snmpIncomingRequest.noResponse();
                        if (this.logger.finestOn()) {
                            this.logger.finest("makeResponseMessage", "'too big' is 'too big' !!!");
                        }
                        this.adaptor.incSnmpSilentDrops(1);
                    }
                    catch (Exception exception) {
                        snmpIncomingRequest.noResponse();
                    }
                }
                catch (Exception exception) {
                    snmpIncomingRequest.noResponse();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SnmpPdu makeResponsePdu(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu, Object object, SnmpRequestForwarder snmpRequestForwarder) {
        SnmpPdu snmpPdu2 = null;
        if (snmpRequestForwarder != null) {
            return this.makeForwardResponsePdu(snmpIncomingRequest, snmpPdu, snmpRequestForwarder);
        }
        this.adaptor.updateRequestCounters(snmpPdu.type);
        if (snmpPdu.varBindList != null) {
            this.adaptor.updateVarCounters(snmpPdu.type, snmpPdu.varBindList.length);
        }
        if (!this.checkPduType(snmpPdu)) return snmpPdu2;
        if (this.currentMibs.size() < 1) {
            if (!this.logger.finerOn()) return this.makeNoMibErrorPdu(snmpPdu, object);
            this.logger.finer("makeResponsePdu", "Request " + snmpPdu.requestId + " received but no MIB registered.");
            return this.makeNoMibErrorPdu(snmpPdu, object);
        }
        if (this.logger.finestOn()) {
            this.logger.finer("makeResponsePdu", "Testing access for : Principal : " + snmpIncomingRequest.getPrincipal() + " \n" + "Snmp version : " + snmpPdu.version + " \n" + "Security level : " + snmpIncomingRequest.getSecurityLevel() + " \n" + "Pdu type : " + snmpPdu.type + " \n" + "Security model : " + snmpIncomingRequest.getSecurityModel() + " \n" + " Access context : " + snmpIncomingRequest.getAccessContext() + " \n");
        }
        try {
            this.accessSubSys.checkPduAccess(snmpPdu.version, snmpIncomingRequest.getPrincipal(), snmpIncomingRequest.getSecurityLevel(), snmpPdu.type, snmpIncomingRequest.getSecurityModel(), snmpIncomingRequest.getAccessContext(), snmpPdu);
        }
        catch (SnmpStatusException snmpStatusException) {
            int n = -1;
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePdu", "authorization failed : " + snmpStatusException.getStatus());
            }
            switch (snmpStatusException.getStatus()) {
                case 2: {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePdu", " update noSuchName counter");
                    }
                    this.adaptor.updateErrorCounters(2);
                }
                case 4: {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePdu", " update bad community uses");
                    }
                    this.adaptor.incSnmpInBadCommunityUses(1);
                    InetAddressAcl inetAddressAcl = this.adaptor.getInetAddressAcl();
                    String string = new String(snmpIncomingRequest.getAccessContext());
                    if (!inetAddressAcl.checkCommunity(string)) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("makeResponsePdu", "update bad community names");
                        }
                        this.adaptor.incSnmpInBadCommunityNames(1);
                    }
                    if (!this.adaptor.getAuthRespEnabled()) {
                        snmpPdu2 = null;
                        snmpIncomingRequest.noResponse();
                    } else {
                        n = SnmpSubRequestHandler.mapErrorStatus(16, snmpPdu.version, snmpPdu.type);
                        snmpPdu2 = this.newErrorResponsePdu(snmpPdu, n, 0);
                    }
                    if (!this.adaptor.getAuthTrapEnabled()) return snmpPdu2;
                    try {
                        this.adaptor.snmpV1Trap(4, 0, new SnmpVarBindList());
                        return snmpPdu2;
                    }
                    catch (Exception exception) {
                        if (!this.logger.finestOn()) return snmpPdu2;
                        this.logger.finest("makeResponsePdu", "failure when sending authentication trap");
                        this.logger.finest("makeResponsePdu", exception);
                    }
                    return snmpPdu2;
                }
                case 20: {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePdu", "No such context context. Dropping the request");
                    }
                    snmpIncomingRequest.noResponse();
                    return null;
                }
            }
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePdu", "AuthorizationError.");
            }
            n = SnmpSubRequestHandler.mapErrorStatus(16, snmpPdu.version, snmpPdu.type);
            if (!this.logger.finerOn()) return this.newErrorResponsePdu(snmpPdu, n, 0);
            this.logger.finer("makeResponsePdu", "Mapped status : " + n);
            return this.newErrorResponsePdu(snmpPdu, n, 0);
        }
        catch (SnmpUnknownAccContrModelException snmpUnknownAccContrModelException) {
            if (!this.logger.finerOn()) return this.newErrorResponsePdu(snmpPdu, 5, 0);
            this.logger.finer("makeResponsePdu", "SnmpUnknownAccContrModelException");
            return this.newErrorResponsePdu(snmpPdu, 5, 0);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("makeResponsePdu", "Access Granted to " + snmpIncomingRequest.getPrincipal());
        }
        switch (snmpPdu.type) {
            case 160: 
            case 161: 
            case 163: {
                return this.makeGetSetResponsePdu(snmpIncomingRequest, snmpPdu, object);
            }
            case 165: {
                return this.makeGetBulkResponsePdu(snmpIncomingRequest, (SnmpPduBulkType)((Object)snmpPdu), object);
            }
        }
        return snmpPdu2;
    }

    private SnmpPdu makeForwardResponsePdu(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu, SnmpRequestForwarder snmpRequestForwarder) {
        try {
            return snmpRequestForwarder.forward(snmpPdu);
        }
        catch (SnmpStatusException snmpStatusException) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeForwardResponsePdu", "Failure when forwarding, return null.");
            }
            return null;
        }
    }

    SnmpPdu makeErrorVarbindPdu(SnmpPdu snmpPdu, int n) {
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        int n2 = snmpVarBindArray.length;
        switch (n) {
            case 130: {
                for (int i = 0; i < n2; ++i) {
                    snmpVarBindArray[i].setSnmpValue(SnmpVarBind.endOfMibView);
                }
                break;
            }
            case 128: {
                for (int i = 0; i < n2; ++i) {
                    snmpVarBindArray[i].setSnmpValue(SnmpVarBind.noSuchObject);
                }
                break;
            }
            case 129: {
                for (int i = 0; i < n2; ++i) {
                    snmpVarBindArray[i].setSnmpValue(SnmpVarBind.noSuchInstance);
                }
                break;
            }
            default: {
                return this.newErrorResponsePdu(snmpPdu, 5, 1);
            }
        }
        return this.newValidResponsePdu(snmpPdu, snmpVarBindArray);
    }

    SnmpPdu makeNoMibErrorPdu(SnmpPdu snmpPdu, Object object) {
        if (snmpPdu.version == 0) {
            return this.newErrorResponsePdu(snmpPdu, 2, 1);
        }
        if (snmpPdu.version == 1 || snmpPdu.version == 3) {
            switch (snmpPdu.type) {
                case 163: 
                case 253: {
                    return this.newErrorResponsePdu(snmpPdu, 6, 1);
                }
                case 160: {
                    return this.makeErrorVarbindPdu(snmpPdu, 128);
                }
                case 161: 
                case 165: {
                    return this.makeErrorVarbindPdu(snmpPdu, 130);
                }
            }
        }
        return this.newErrorResponsePdu(snmpPdu, 5, 1);
    }

    private SnmpPdu makeGetSetResponsePdu(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu, Object object) {
        if (snmpPdu.varBindList == null) {
            return this.newValidResponsePdu(snmpPdu, null);
        }
        SnmpPdu snmpPdu2 = null;
        snmpPdu2 = this.splitRequest(snmpIncomingRequest, snmpPdu);
        if (snmpPdu2 != null) {
            return snmpPdu2;
        }
        int n = this.subs.size();
        if (n == 1) {
            return this.turboProcessingGetSet(snmpPdu, object);
        }
        snmpPdu2 = this.executeSubRequest(snmpPdu, object);
        if (snmpPdu2 != null) {
            return snmpPdu2;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("makeGetSetResponsePdu", "Build the unified response for request " + snmpPdu.requestId);
        }
        return this.mergeResponses(snmpPdu);
    }

    private SnmpPdu executeSubRequest(SnmpPdu snmpPdu, Object object) {
        SnmpSubRequestHandler snmpSubRequestHandler;
        Enumeration enumeration;
        int n;
        int n2 = 0;
        int n3 = this.subs.size();
        if (snmpPdu.type == 163) {
            n = 0;
            enumeration = this.subs.elements();
            while (enumeration.hasMoreElements()) {
                snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
                snmpSubRequestHandler.setUserData(object);
                snmpSubRequestHandler.type = 253;
                snmpSubRequestHandler.run();
                snmpSubRequestHandler.type = 163;
                if (snmpSubRequestHandler.getErrorStatus() != 0) {
                    return this.newErrorResponsePdu(snmpPdu, n2, snmpSubRequestHandler.getErrorIndex() + 1);
                }
                ++n;
            }
        }
        n = 0;
        enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.setUserData(object);
            snmpSubRequestHandler.run();
            if (snmpSubRequestHandler.getErrorStatus() != 0) {
                if (this.logger.finestOn()) {
                    this.logger.finest("executeSubRequest", "an error occurs");
                }
                int n4 = snmpSubRequestHandler.getErrorIndex() + 1;
                return this.newErrorResponsePdu(snmpPdu, n2, n4);
            }
            ++n;
        }
        return null;
    }

    private SnmpPdu turboProcessingGetSet(SnmpPdu snmpPdu, Object object) {
        int n = 0;
        SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)this.subs.elements().nextElement();
        snmpSubRequestHandler.setUserData(object);
        if (snmpPdu.type == 163) {
            snmpSubRequestHandler.type = 253;
            snmpSubRequestHandler.run();
            snmpSubRequestHandler.type = 163;
            n = snmpSubRequestHandler.getErrorStatus();
            if (n != 0) {
                return this.newErrorResponsePdu(snmpPdu, n, snmpSubRequestHandler.getErrorIndex() + 1);
            }
        }
        snmpSubRequestHandler.run();
        n = snmpSubRequestHandler.getErrorStatus();
        if (n != 0) {
            if (this.logger.finestOn()) {
                this.logger.finest("turboProcessingGetSet", "an error occurs");
            }
            int n2 = snmpSubRequestHandler.getErrorIndex() + 1;
            return this.newErrorResponsePdu(snmpPdu, n, n2);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("turboProcessingGetSet", "build the unified response for request " + snmpPdu.requestId);
        }
        return this.mergeResponses(snmpPdu);
    }

    private SnmpPdu makeGetBulkResponsePdu(SnmpIncomingRequest snmpIncomingRequest, SnmpPduBulkType snmpPduBulkType, Object object) {
        int n;
        int n2;
        int n3;
        SnmpVarBind[] snmpVarBindArray = null;
        SnmpVarBind[] snmpVarBindArray2 = ((SnmpPdu)((Object)snmpPduBulkType)).varBindList;
        if (snmpVarBindArray2 == null) {
            return this.newValidResponsePdu((SnmpPdu)((Object)snmpPduBulkType), null);
        }
        int n4 = snmpVarBindArray2.length;
        int n5 = Math.max(Math.min(snmpPduBulkType.getNonRepeaters(), n4), 0);
        SnmpPdu snmpPdu = this.splitBulkRequest(snmpIncomingRequest, snmpPduBulkType, n5, n3 = Math.max(snmpPduBulkType.getMaxRepetitions(), 0), n2 = n4 - n5);
        if (snmpPdu != null) {
            return snmpPdu;
        }
        snmpPdu = this.executeSubRequest((SnmpPdu)((Object)snmpPduBulkType), object);
        if (snmpPdu != null) {
            return snmpPdu;
        }
        snmpVarBindArray = this.mergeBulkResponses(n5 + n3 * n2);
        for (n = snmpVarBindArray.length; n > n5 && snmpVarBindArray[n - 1].getSnmpValue().equals(SnmpVarBind.endOfMibView); --n) {
        }
        int n6 = n == n5 ? n5 + n2 : n5 + ((n - 1 - n5) / n2 + 2) * n2;
        if (n6 < snmpVarBindArray.length) {
            SnmpVarBind[] snmpVarBindArray3 = new SnmpVarBind[n6];
            for (int i = 0; i < n6; ++i) {
                snmpVarBindArray3[i] = snmpVarBindArray[i];
            }
            snmpVarBindArray = snmpVarBindArray3;
        }
        return this.newValidResponsePdu((SnmpPdu)((Object)snmpPduBulkType), snmpVarBindArray);
    }

    private boolean checkPduType(SnmpPdu snmpPdu) {
        boolean bl = true;
        if (snmpPdu.type == 165 && snmpPdu.version == 0 && this.logger.finestOn()) {
            this.logger.finest("checkPduType", "Received a getbulk in V1, rejecting the request");
            return false;
        }
        switch (snmpPdu.type) {
            case 160: 
            case 161: 
            case 163: 
            case 165: {
                bl = true;
                break;
            }
            default: {
                if (this.logger.finestOn()) {
                    this.logger.finest("checkPduType", "cannot respond to this kind of PDU");
                }
                bl = false;
            }
        }
        return bl;
    }

    private SnmpPdu newValidResponsePdu(SnmpPdu snmpPdu, SnmpVarBind[] snmpVarBindArray) {
        SnmpPdu snmpPdu2 = null;
        SnmpAckPdu snmpAckPdu = (SnmpAckPdu)((Object)snmpPdu);
        snmpPdu2 = snmpAckPdu.getResponsePdu();
        snmpPdu2.varBindList = snmpVarBindArray;
        this.adaptor.updateErrorCounters(((SnmpPduRequestType)((Object)snmpPdu2)).getErrorStatus());
        return snmpPdu2;
    }

    private SnmpPdu newErrorResponsePdu(SnmpPdu snmpPdu, int n, int n2) {
        SnmpPduRequestType snmpPduRequestType = (SnmpPduRequestType)((Object)this.newValidResponsePdu(snmpPdu, null));
        snmpPduRequestType.setErrorStatus(n);
        snmpPduRequestType.setErrorIndex(n2);
        ((SnmpPdu)((Object)snmpPduRequestType)).varBindList = snmpPdu.varBindList;
        this.adaptor.updateErrorCounters(snmpPduRequestType.getErrorStatus());
        return (SnmpPdu)((Object)snmpPduRequestType);
    }

    private void newTooBigMessage(SnmpIncomingRequest snmpIncomingRequest) throws SnmpTooBigException {
        Object var2_2 = null;
        SnmpPdu snmpPdu = null;
        try {
            snmpPdu = snmpIncomingRequest.decodeSnmpPdu();
            if (snmpPdu != null) {
                SnmpPdu snmpPdu2 = this.newTooBigPdu(snmpPdu);
                snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, this.packet.getData().length);
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            throw new InternalError();
        }
    }

    private SnmpPdu newTooBigPdu(SnmpPdu snmpPdu) {
        SnmpPdu snmpPdu2 = this.newErrorResponsePdu(snmpPdu, 1, 0);
        snmpPdu2.varBindList = null;
        return snmpPdu2;
    }

    private SnmpPdu reduceResponsePdu(SnmpPdu snmpPdu, SnmpPdu snmpPdu2, int n) throws SnmpTooBigException {
        if (snmpPdu.type != 165) {
            if (this.logger.finestOn()) {
                this.logger.finest("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(n);
        }
        int n2 = snmpPdu2.varBindList.length;
        n2 = n >= 3 ? Math.min(n - 1, snmpPdu2.varBindList.length) : (n == 1 ? 1 : snmpPdu2.varBindList.length / 2);
        if (n2 < 1) {
            if (this.logger.finestOn()) {
                this.logger.finest("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(n);
        }
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        for (int i = 0; i < n2; ++i) {
            snmpVarBindArray[i] = snmpPdu2.varBindList[i];
        }
        if (this.logger.finestOn()) {
            this.logger.finest("reduceResponsePdu", snmpPdu2.varBindList.length - snmpVarBindArray.length + " items have been removed");
        }
        snmpPdu2.varBindList = snmpVarBindArray;
        return snmpPdu2;
    }

    private SnmpPdu handleAccessException(int n, int n2, SnmpPdu snmpPdu, SnmpVarBind snmpVarBind, SnmpAdaptorServer snmpAdaptorServer) {
        SnmpPdu snmpPdu2 = null;
        int n3 = 0;
        if (snmpPdu.version != 3) {
            block12: {
                if (!snmpAdaptorServer.getAuthRespEnabled()) {
                    // empty if block
                }
                if (snmpAdaptorServer.getAuthTrapEnabled()) {
                    try {
                        snmpAdaptorServer.snmpV1Trap(4, 0, new SnmpVarBindList());
                    }
                    catch (Exception exception) {
                        if (!this.logger.finestOn()) break block12;
                        this.logger.finest("handleAccessException", "failure when sending authentication trap");
                        this.logger.finest("handleAccessException", exception);
                    }
                }
            }
            if (snmpPdu.version == 0) {
                n3 = SnmpSubRequestHandler.mapErrorStatus(n, snmpPdu.version, snmpPdu.type);
                snmpPdu2 = this.newErrorResponsePdu(snmpPdu, n3, n2);
            } else {
                n3 = SnmpSubRequestHandler.mapErrorStatus(n, snmpPdu.version, snmpPdu.type);
                if (snmpPdu.type == 163) {
                    snmpPdu2 = this.newErrorResponsePdu(snmpPdu, n3, n2);
                } else {
                    snmpVarBind.setSnmpValue(new SnmpNull(n3));
                }
            }
        } else {
            n3 = SnmpSubRequestHandler.mapErrorStatus(n, snmpPdu.version, snmpPdu.type);
            if (snmpPdu.type == 163) {
                snmpPdu2 = this.newErrorResponsePdu(snmpPdu, n3, n2);
            } else {
                snmpVarBind.setSnmpValue(new SnmpNull(n3));
            }
        }
        return snmpPdu2;
    }

    private Object checkOidAccess(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu, SnmpVarBind snmpVarBind, int n) {
        SnmpPdu snmpPdu2 = null;
        try {
            this.accessSubSys.checkAccess(snmpPdu.version, snmpIncomingRequest.getPrincipal(), snmpIncomingRequest.getSecurityLevel(), snmpPdu.type, snmpIncomingRequest.getSecurityModel(), snmpIncomingRequest.getAccessContext(), snmpVarBind.getOid());
        }
        catch (SnmpStatusException snmpStatusException) {
            switch (snmpStatusException.getStatus()) {
                default: 
            }
            if (this.logger.finerOn()) {
                this.logger.finer("checkOidAccess", "SnmpStatusException : " + snmpStatusException.getStatus());
            }
            if (snmpPdu.version == 0) {
                snmpPdu2 = this.newErrorResponsePdu(snmpPdu, 2, n + 1);
                return snmpPdu2;
            }
            return SnmpVarBind.noSuchInstance;
        }
        catch (SnmpUnknownAccContrModelException snmpUnknownAccContrModelException) {
            snmpPdu2 = this.newErrorResponsePdu(snmpPdu, 5, n + 1);
        }
        return snmpPdu2;
    }

    private SnmpPdu splitRequest(SnmpIncomingRequest snmpIncomingRequest, SnmpPdu snmpPdu) {
        Object var3_3 = null;
        int n = this.currentMibs.size();
        if (this.logger.finerOn()) {
            this.logger.finer("splitRequest", "Nb agents : " + n);
        }
        SnmpSubRequestHandler snmpSubRequestHandler = null;
        int n2 = snmpPdu.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpMibAgent snmpMibAgent = null;
        if (snmpPdu.type == 161) {
            if (this.logger.finerOn()) {
                this.logger.finer("splitRequest", "Doing getNext on muliple agents");
            }
            Enumeration enumeration = this.currentMibs.elements();
            while (enumeration.hasMoreElements()) {
                SnmpSubNextRequestHandler snmpSubNextRequestHandler = null;
                SnmpMibAgent snmpMibAgent2 = (SnmpMibAgent)enumeration.nextElement();
                snmpSubNextRequestHandler = new SnmpSubNextRequestHandler((SnmpEngine)this.engine, snmpIncomingRequest, snmpMibAgent2, snmpPdu, this.currentRoot);
                this.subs.put(snmpMibAgent2, snmpSubNextRequestHandler);
                if (!this.logger.finerOn()) continue;
                this.logger.finer("splitRequest", "Doing getNext on agent [" + snmpMibAgent2 + "]");
            }
            return null;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("splitRequest", "Access Granted to " + snmpIncomingRequest.getPrincipal() + n2);
        }
        Object object = null;
        for (int i = 0; i < n2; ++i) {
            object = this.checkOidAccess(snmpIncomingRequest, snmpPdu, snmpVarBindArray[i], i);
            if (object != null) {
                if (this.logger.finestOn()) {
                    this.logger.finest("splitRequest", "Access NOT granted for OID:" + snmpVarBindArray[i].getOid());
                }
                if (object instanceof SnmpPdu) {
                    return (SnmpPdu)object;
                }
                snmpVarBindArray[i].setSnmpValue((SnmpValue)object);
                continue;
            }
            if (this.logger.finestOn()) {
                this.logger.finest("splitRequest", "Access granted for OID : " + snmpVarBindArray[i].getOid());
            }
            snmpMibAgent = this.currentRoot.getAgentMib(snmpVarBindArray[i].getOid());
            if (this.logger.finerOn()) {
                this.logger.finer("splitRequest", "Found mib [" + snmpMibAgent + "] for oid " + snmpVarBindArray[i].getOid());
            }
            if ((snmpSubRequestHandler = (SnmpSubRequestHandler)this.subs.get(snmpMibAgent)) == null) {
                snmpSubRequestHandler = new SnmpSubRequestHandler(this.engine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
                this.subs.put(snmpMibAgent, snmpSubRequestHandler);
            }
            snmpSubRequestHandler.updateRequest(snmpVarBindArray[i], i);
        }
        return null;
    }

    private SnmpPdu splitBulkRequest(SnmpIncomingRequest snmpIncomingRequest, SnmpPduBulkType snmpPduBulkType, int n, int n2, int n3) {
        int n4 = this.currentMibs.size();
        if (n4 == 1) {
            SnmpMibAgent snmpMibAgent = (SnmpMibAgent)this.currentMibs.firstElement();
            this.subs.put(snmpMibAgent, new SnmpSubBulkRequestHandler(this.engine, snmpIncomingRequest, snmpMibAgent, (SnmpPdu)((Object)snmpPduBulkType), n, n2, n3, this.currentRoot));
            return null;
        }
        Enumeration enumeration = this.currentMibs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubBulkRequestHandler snmpSubBulkRequestHandler = null;
            SnmpMibAgent snmpMibAgent = (SnmpMibAgent)enumeration.nextElement();
            snmpSubBulkRequestHandler = new SnmpSubBulkRequestHandler(this.engine, snmpIncomingRequest, snmpMibAgent, (SnmpPdu)((Object)snmpPduBulkType), n, n2, n3, this.currentRoot);
            this.subs.put(snmpMibAgent, snmpSubBulkRequestHandler);
        }
        return null;
    }

    private SnmpPdu mergeResponses(SnmpPdu snmpPdu) {
        if (snmpPdu.type == 161) {
            return this.mergeNextResponses(snmpPdu);
        }
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        return this.newValidResponsePdu(snmpPdu, snmpVarBindArray);
    }

    private SnmpPdu mergeNextResponses(SnmpPdu snmpPdu) {
        Object object;
        int n = snmpPdu.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            object = (SnmpSubRequestHandler)enumeration.nextElement();
            ((SnmpSubRequestHandler)object).updateResult(snmpVarBindArray);
        }
        if (snmpPdu.version == 1 || snmpPdu.version == 3) {
            return this.newValidResponsePdu(snmpPdu, snmpVarBindArray);
        }
        for (int i = 0; i < n; ++i) {
            object = snmpVarBindArray[i].getSnmpValue();
            if (object != SnmpVarBind.endOfMibView) continue;
            return this.newErrorResponsePdu(snmpPdu, 2, i + 1);
        }
        return this.newValidResponsePdu(snmpPdu, snmpVarBindArray);
    }

    private SnmpVarBind[] mergeBulkResponses(int n) {
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
        for (int i = n - 1; i >= 0; --i) {
            snmpVarBindArray[i] = new SnmpVarBind();
            snmpVarBindArray[i].setSnmpValue(SnmpVarBind.endOfMibView);
        }
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSubRequestHandler snmpSubRequestHandler = (SnmpSubRequestHandler)enumeration.nextElement();
            snmpSubRequestHandler.updateResult(snmpVarBindArray);
        }
        return snmpVarBindArray;
    }

    protected String makeDebugTag() {
        return "SnmpV3RequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "]";
    }

    ClassLogger makeLogger(String string) {
        return new ClassLogger("com.sun.jdmk.snmp.adaptor", string);
    }

    Thread createThread(Runnable runnable) {
        return null;
    }
}

