/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.ThreadContext;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;

class SnmpSubBulkRequestHandler
extends SnmpSubRequestHandler {
    private SnmpMibTree root = null;
    protected int nonRepeat = 0;
    protected int maxRepeat = 0;
    protected int globalR = 0;
    protected int size = 0;

    protected SnmpSubBulkRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, int n, int n2, int n3, SnmpMibTree snmpMibTree) {
        super(snmpEngine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
        this.init(snmpPdu, n, n2, n3, snmpMibTree);
    }

    protected SnmpSubBulkRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, int n, int n2, int n3, SnmpMibTree snmpMibTree) {
        super(snmpMibAgent, snmpPdu);
        this.init(snmpPdu, n, n2, n3, snmpMibTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            this.size = this.varBind.size();
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (this.logger.finerOn()) {
                        this.logger.finer("run", "[" + Thread.currentThread() + "]:getBulk operation on " + this.agent.getMibName());
                    }
                    this.agent.getBulk(this.createMibRequest(this.varBind, this.version, this.data), this.nonRepeat, this.maxRepeat);
                }
                finally {
                    ThreadContext.restore(threadContext);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation");
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "[" + Thread.currentThread() + "]: Unexpected exception: " + exception);
                    this.logger.finest("run", exception);
                }
                if (!this.logger.finerOn()) break block10;
                this.logger.finer("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    private void init(SnmpPdu snmpPdu, int n, int n2, int n3, SnmpMibTree snmpMibTree) {
        this.root = snmpMibTree;
        this.nonRepeat = n;
        this.maxRepeat = n2;
        this.globalR = n3;
        int n4 = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVector = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i = 0; i < n4; ++i) {
            this.translation[i] = i;
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpVarBindArray[i].getOid(), snmpVarBindArray[i].getSnmpValue());
            nonSyncVector.addNonSyncElement(snmpVarBind);
        }
    }

    private SnmpVarBind findVarBind(SnmpVarBind snmpVarBind, SnmpVarBind snmpVarBind2) {
        if (snmpVarBind == null) {
            return null;
        }
        if (snmpVarBind2.getOid() == null) {
            return snmpVarBind;
        }
        if (snmpVarBind.getSnmpValue() == SnmpVarBind.endOfMibView) {
            return snmpVarBind2;
        }
        if (snmpVarBind2.getSnmpValue() == SnmpVarBind.endOfMibView) {
            return snmpVarBind;
        }
        SnmpValue snmpValue = snmpVarBind2.getSnmpValue();
        int n = snmpVarBind.getOid().compareTo(snmpVarBind2.getOid());
        if (this.logger.finestOn()) {
            this.logger.finest("findVarBind", "Comparing OID element : " + snmpVarBind.getOid() + " with result : " + snmpVarBind2.getOid());
            this.logger.finest("findVarBind", "Values element : " + snmpVarBind.getSnmpValue() + " result : " + snmpVarBind2.getSnmpValue());
        }
        if (n < 0) {
            return snmpVarBind;
        }
        if (n == 0) {
            if (this.logger.finestOn()) {
                this.logger.finest("findVarBind", " oid overlapping. Oid : " + snmpVarBind.getOid() + "value :" + snmpVarBind.getSnmpValue());
                this.logger.finest("findVarBind", "Already present varBind : " + snmpVarBind2);
            }
            SnmpOid snmpOid = snmpVarBind2.getOid();
            SnmpMibAgent snmpMibAgent = this.root.getAgentMib(snmpOid);
            if (this.logger.finestOn()) {
                this.logger.finest("findVarBind", "Deeper agent : " + snmpMibAgent);
            }
            if (snmpMibAgent == this.agent) {
                if (this.logger.finestOn()) {
                    this.logger.finest("updateResult", "The current agent is the deeper one. Update the value with the current one");
                }
                return snmpVarBind;
            }
            if (this.logger.finestOn()) {
                this.logger.finest("updateResult", "Current is not the deeper, return the previous one.");
            }
            return snmpVarBind2;
        }
        if (this.logger.finestOn()) {
            this.logger.finest("findVarBind", "The right varBind is the already present one");
        }
        return snmpVarBind2;
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n;
        int n2;
        Enumeration enumeration = this.varBind.elements();
        int n3 = snmpVarBindArray.length;
        for (n2 = 0; n2 < this.size; ++n2) {
            SnmpVarBind snmpVarBind;
            if (!enumeration.hasMoreElements()) {
                return;
            }
            n = this.translation[n2];
            if (n >= n3) {
                if (!this.logger.finestOn()) continue;
                this.logger.finest("updateResult", "Position `" + n + "' is out of bound...");
                continue;
            }
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            if (snmpVarBind2 == null) continue;
            if (this.logger.finestOn()) {
                this.logger.finest("updateResult", "Non repeaters Current element : " + snmpVarBind2 + " from agent : " + this.agent);
            }
            if ((snmpVarBind = this.findVarBind(snmpVarBind2, snmpVarBindArray[n])) == null) continue;
            snmpVarBindArray[n] = snmpVarBind;
        }
        n2 = this.size - this.nonRepeat;
        for (n = 2; n <= this.maxRepeat; ++n) {
            for (int i = 0; i < n2; ++i) {
                SnmpVarBind snmpVarBind;
                int n4 = (n - 1) * this.globalR + this.translation[this.nonRepeat + i];
                if (n4 >= n3) {
                    return;
                }
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                SnmpVarBind snmpVarBind3 = (SnmpVarBind)enumeration.nextElement();
                if (snmpVarBind3 == null) continue;
                if (this.logger.finestOn()) {
                    this.logger.finest("updateResult", "Repeaters Current element : " + snmpVarBind3 + " from agent : " + this.agent);
                }
                if ((snmpVarBind = this.findVarBind(snmpVarBind3, snmpVarBindArray[n4])) == null) continue;
                snmpVarBindArray[n4] = snmpVarBind;
            }
        }
    }

    protected String makeDebugTag() {
        return "SnmpSubBulkRequestHandler";
    }
}

