/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpResponseHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

final class SnmpSocket
implements Runnable {
    private DatagramSocket _socket = null;
    private SnmpResponseHandler _dgramHdlr = null;
    private Thread _sockThread = null;
    private byte[] _buffer = null;
    private transient boolean isClosing = false;
    int _socketPort = 0;
    int responseBufSize = 1024;
    String dbgTag = "SnmpSocket";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpSocket");

    public SnmpSocket(SnmpResponseHandler snmpResponseHandler, InetAddress inetAddress, int n) throws SocketException {
        if (logger.finerOn()) {
            logger.finer("constructor", "Creating new SNMP datagram socket");
        }
        this._socket = new DatagramSocket(0, inetAddress);
        this._socketPort = this._socket.getLocalPort();
        this.responseBufSize = n;
        this._buffer = new byte[this.responseBufSize];
        this._dgramHdlr = snmpResponseHandler;
        this._sockThread = new Thread((Runnable)this, "SnmpSocket");
        this._sockThread.start();
    }

    public synchronized void sendPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetAddress, n2);
        this.sendPacket(datagramPacket);
    }

    public synchronized void sendPacket(DatagramPacket datagramPacket) throws IOException {
        try {
            if (this.isValid()) {
                if (logger.finerOn()) {
                    logger.finer("sendPacket", "Sending DatagramPacket. Length = " + datagramPacket.getLength() + " through socket = " + this._socket.toString());
                }
            } else {
                throw new IOException("Invalid state of SNMP datagram socket.");
            }
            this._socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            if (logger.finestOn()) {
                logger.finest("sendPacket", "Io error while sending");
                logger.finest("sendPacket", iOException);
            }
            throw iOException;
        }
    }

    public synchronized boolean isValid() {
        return this._socket != null && this._sockThread != null && this._sockThread.isAlive();
    }

    public synchronized void close() {
        this.isClosing = true;
        if (logger.finerOn()) {
            logger.finer("close", "Closing and destroying the SNMP datagram socket -> " + this.toString());
        }
        try {
            DatagramSocket datagramSocket = new DatagramSocket(0);
            byte[] byArray = new byte[1];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, 1, InetAddress.getLocalHost(), this._socketPort);
            datagramSocket.send(datagramPacket);
            datagramSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (this._sockThread != null && this._sockThread.isAlive()) {
            this._sockThread.interrupt();
            try {
                this._sockThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._sockThread = null;
        }
    }

    public void run() {
        Thread.currentThread().setPriority(8);
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket datagramPacket = new DatagramPacket(this._buffer, this._buffer.length);
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Blocking for receiving packet");
                    }
                    this._socket.receive(datagramPacket);
                    if (this.isClosing) break block5;
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet");
                    }
                    if (datagramPacket.getLength() <= 0) continue;
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet from : " + datagramPacket.getAddress().toString() + ", Length = " + datagramPacket.getLength());
                    }
                    this.handleDatagram(datagramPacket);
                    if (this.isClosing) break;
                }
            }
            catch (IOException iOException) {
                if (this.isClosing) break;
                if (!logger.finestOn()) continue;
                logger.finest("run", iOException);
                continue;
            }
            catch (Exception exception) {
                if (this.isClosing) break;
                if (!logger.finestOn()) continue;
                logger.finest("run", "Exception in socket thread...");
                logger.finest("run", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (logger.finestOn()) {
                    logger.finest("run", "Socket Thread DEAD..." + this.toString());
                    logger.finest("run", threadDeath);
                }
                this.close();
                throw threadDeath;
            }
            catch (Error error) {
                if (logger.finestOn()) {
                    logger.finest("run", error);
                }
                this.handleJavaError(error);
                continue;
            }
            break;
        }
    }

    public synchronized void finalize() {
        this.close();
    }

    private synchronized void handleJavaError(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            if (logger.finestOn()) {
                logger.finest("handleJavaError", throwable);
            }
            Thread.currentThread();
            Thread.yield();
            return;
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (logger.finestOn()) {
            logger.finest("handleJavaError", "Global Internal error");
        }
        Thread.currentThread();
        Thread.yield();
    }

    private synchronized void handleDatagram(DatagramPacket datagramPacket) {
        this._dgramHdlr.processDatagram(datagramPacket);
    }
}

