/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading.proxy;

import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class CascadingProxy
implements DynamicMBean,
MBeanRegistration,
NotificationEmitter {
    private List listenerList;
    private final MBeanServerConnectionFactory connectionFactory;
    private final ObjectName source;
    private ObjectName targetName;

    public CascadingProxy(ObjectName objectName, MBeanServerConnectionFactory mBeanServerConnectionFactory) {
        this.connectionFactory = mBeanServerConnectionFactory;
        this.source = objectName;
        this.targetName = null;
        this.listenerList = Collections.EMPTY_LIST;
    }

    RuntimeException handleIOException(IOException iOException, String string) {
        UndeclaredThrowableException undeclaredThrowableException = new UndeclaredThrowableException(iOException);
        return undeclaredThrowableException;
    }

    RuntimeException handleInstanceNotFoundException(InstanceNotFoundException instanceNotFoundException, String string) {
        UndeclaredThrowableException undeclaredThrowableException = new UndeclaredThrowableException(instanceNotFoundException);
        return undeclaredThrowableException;
    }

    RuntimeException handleCheckedException(Exception exception, String string) {
        UndeclaredThrowableException undeclaredThrowableException = new UndeclaredThrowableException(exception);
        return undeclaredThrowableException;
    }

    private MBeanServerConnection connection() throws IOException {
        MBeanServerConnection mBeanServerConnection = this.connectionFactory.getMBeanServerConnection();
        if (mBeanServerConnection == null) {
            throw new IOException("MBeanServerConnection unavailable");
        }
        return mBeanServerConnection;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.connection().getAttribute(this.source, string);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getAttribute");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw this.handleInstanceNotFoundException(instanceNotFoundException, "getAttribute");
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.connection().setAttribute(this.source, attribute);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "setAttribute");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw this.handleInstanceNotFoundException(instanceNotFoundException, "setAttribute");
        }
    }

    public AttributeList getAttributes(String[] stringArray) {
        try {
            return this.connection().getAttributes(this.source, stringArray);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getAttributes");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw this.handleInstanceNotFoundException(instanceNotFoundException, "getAttributes");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw this.handleCheckedException(exception, "getAttributes");
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        try {
            return this.connection().setAttributes(this.source, attributeList);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "setAttributes");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw this.handleInstanceNotFoundException(instanceNotFoundException, "setAttributes");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw this.handleCheckedException(exception, "setAttributes");
        }
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        try {
            return this.connection().invoke(this.source, string, objectArray, stringArray);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "invoke");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw this.handleInstanceNotFoundException(instanceNotFoundException, "invoke");
        }
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return this.connection().getMBeanInfo(this.source);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getMBeanInfo");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw this.handleInstanceNotFoundException(instanceNotFoundException, "getMBeanInfo");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw this.handleCheckedException(exception, "getMBeanInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            throw new IllegalArgumentException("Illegal ObjectName: null");
        }
        CascadingProxy cascadingProxy = this;
        synchronized (cascadingProxy) {
            this.targetName = objectName;
        }
        return this.targetName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public final ObjectName getSourceMBeanName() {
        return this.source;
    }

    public synchronized ObjectName getTargetName() {
        return this.targetName;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        try {
            MBeanNotificationInfo[] mBeanNotificationInfoArray = this.getMBeanInfo().getNotifications();
            if (mBeanNotificationInfoArray == null) {
                return new MBeanNotificationInfo[0];
            }
            return mBeanNotificationInfoArray;
        }
        catch (Exception exception) {
            return new MBeanNotificationInfo[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        CascadingProxy cascadingProxy = this;
        synchronized (cascadingProxy) {
            ListenerWrapper listenerWrapper = new ListenerWrapper(notificationListener, notificationFilter, object);
            try {
                this.connection().addNotificationListener(this.source, listenerWrapper, notificationFilter, object);
                ArrayList<ListenerWrapper> arrayList = new ArrayList<ListenerWrapper>(this.listenerList.size() + 1);
                arrayList.addAll(this.listenerList);
                arrayList.add(listenerWrapper);
                this.listenerList = arrayList;
            }
            catch (IOException iOException) {
                throw this.handleIOException(iOException, "addNotificationListener");
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw this.handleInstanceNotFoundException(instanceNotFoundException, "addNotificationListener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        CascadingProxy cascadingProxy = this;
        synchronized (cascadingProxy) {
            ArrayList arrayList = new ArrayList(this.listenerList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ListenerWrapper listenerWrapper = (ListenerWrapper)arrayList.get(i);
                if (listenerWrapper.listener != notificationListener) continue;
                try {
                    this.connection().removeNotificationListener(this.source, listenerWrapper);
                    arrayList.remove(i);
                    continue;
                }
                catch (IOException iOException) {
                    throw this.handleIOException(iOException, "removeNotificationListener");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    throw this.handleInstanceNotFoundException(instanceNotFoundException, "removeNotificationListener");
                }
            }
            if (arrayList.size() == this.listenerList.size()) {
                throw new ListenerNotFoundException("Listener not registered");
            }
            this.listenerList = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        boolean bl = false;
        CascadingProxy cascadingProxy = this;
        synchronized (cascadingProxy) {
            ArrayList arrayList = new ArrayList(this.listenerList);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ListenerWrapper listenerWrapper = (ListenerWrapper)arrayList.get(i);
                if (listenerWrapper.listener != notificationListener) continue;
                bl = true;
                if (listenerWrapper.filter != notificationFilter || listenerWrapper.handback != object) continue;
                try {
                    this.connection().removeNotificationListener(this.source, listenerWrapper, notificationFilter, object);
                    arrayList.remove(i);
                }
                catch (IOException iOException) {
                    throw this.handleIOException(iOException, "removeNotificationListener");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    throw this.handleInstanceNotFoundException(instanceNotFoundException, "removeNotificationListener");
                }
                arrayList.remove(i);
                this.listenerList = arrayList;
                return;
            }
        }
        if (bl) {
            throw new ListenerNotFoundException("Listener not registered with this filter and handback");
        }
        throw new ListenerNotFoundException("Listener not registered");
    }

    public final MBeanServerConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected Notification translate(Notification notification) {
        notification.setSource(this.makeSource(notification.getSource()));
        return notification;
    }

    private Object makeSource(Object object) {
        if (object != null && !object.equals(this.getSourceMBeanName())) {
            return object;
        }
        ObjectName objectName = this.getTargetName();
        if (objectName == null) {
            return this;
        }
        return objectName;
    }

    private final class ListenerWrapper
    implements NotificationListener {
        public final NotificationListener listener;
        final NotificationFilter filter;
        final Object handback;

        public ListenerWrapper(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
        }

        public void handleNotification(Notification notification, Object object) {
            this.listener.handleNotification(CascadingProxy.this.translate(notification), object);
        }
    }
}

