/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm.internal;

import com.sun.jdmk.NotificationRegistration;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatNotification;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpConnectorClient;
import com.sun.jdmk.comm.HttpsConnectorClient;
import com.sun.jdmk.comm.JdmkLegacyConnector;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorClient;
import com.sun.jdmk.comm.internal.EnvHelp;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class JDMKClientConnector
implements JMXConnector,
JdmkLegacyConnector {
    private MBeanServerConnectionImpl serverConnection;
    private final RemoteMBeanServer mserver;
    private final NotificationRegistration nregistry;
    private Map env;
    private JMXServiceURL address;
    private String connectionId = null;
    private static int idCounter = 0;
    private boolean connected = false;
    private boolean terminated = false;
    private final int[] lock = new int[0];
    private final NotificationBroadcasterSupport connectionBroadcaster = new NotificationBroadcasterSupport();
    private final HeartBeatNotifListener myListener = new HeartBeatNotifListener();
    private ClassLogger logger;

    public JDMKClientConnector(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        if (jMXServiceURL == null) {
            throw new IllegalArgumentException("Null url.");
        }
        this.env = map == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(map);
        this.address = jMXServiceURL;
        String string = this.address.getProtocol();
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.client.wrapper", "JDMKClientConnector-" + string);
        if (this.logger.fineOn()) {
            this.logger.fine("Constructor", "Construct a JDMK legacy connector wrapper: " + this.address);
        }
        String string2 = null;
        try {
            string2 = (String)this.env.get("com.sun.jdmk.client.localhost");
        }
        catch (ClassCastException classCastException) {
            IOException iOException = new IOException(classCastException.toString());
            EnvHelp.initCause(iOException, classCastException);
            throw iOException;
        }
        if ("jdmk-rmi".equals(string)) {
            RmiConnectorClient rmiConnectorClient = new RmiConnectorClient(string2);
            this.mserver = rmiConnectorClient;
            this.nregistry = rmiConnectorClient;
            return;
        }
        if ("jdmk-http".equals(string)) {
            HttpConnectorClient httpConnectorClient = new HttpConnectorClient(string2);
            this.mserver = httpConnectorClient;
            this.nregistry = httpConnectorClient;
        } else if ("jdmk-https".equals(string)) {
            boolean bl = true;
            String string3 = (String)map.get("com.sun.jdmk.https.server.need.client.auth");
            if (string3 != null && "false".equals(string3.toLowerCase())) {
                bl = false;
            }
            HttpsConnectorClient httpsConnectorClient = new HttpsConnectorClient(string2, bl);
            this.mserver = httpsConnectorClient;
            this.nregistry = httpsConnectorClient;
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + string);
        }
    }

    public void connect() throws IOException {
        this.connect((Map)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map map) throws IOException {
        if (this.logger.fineOn()) {
            this.logger.fine("connect", "Connecting the client to " + this.address);
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            Object object;
            if (this.terminated) {
                throw new IOException("The client has been closed.");
            }
            if (this.connected) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            HashMap hashMap = new HashMap(this.env);
            if (map != null) {
                EnvHelp.checkAttributes(map);
                hashMap.putAll(map);
            }
            ConnectorAddress connectorAddress = null;
            if ("jdmk-rmi".equals(this.address.getProtocol())) {
                object = this.address.getURLPath();
                int n = ((String)object).indexOf("/");
                if (n < 0 || ((String)object).length() == n + 1) {
                    object = "name=RmiConnectorServer";
                } else if (((String)(object = ((String)object).substring(n + 1))).trim().equals("")) {
                    object = "name=RmiConnectorServer";
                }
                connectorAddress = new RmiConnectorAddress(this.address.getHost(), this.address.getPort(), (String)object);
            } else {
                object = null;
                try {
                    object = (AuthInfo)hashMap.get("com.sun.jdmk.http.client.authinfo");
                }
                catch (ClassCastException classCastException) {
                    IOException iOException = new IOException(classCastException.toString());
                    EnvHelp.initCause(iOException, classCastException);
                    throw iOException;
                }
                connectorAddress = object == null ? new HttpConnectorAddress(this.address.getHost(), this.address.getPort()) : new HttpConnectorAddress(this.address.getHost(), this.address.getPort(), (AuthInfo)object);
            }
            this.connectionId = this.address.getProtocol() + "://" + InetAddress.getLocalHost().getHostName() + ":" + this.address.getPort() + "  " + idCounter++;
            ((HeartBeatClientHandler)((Object)this.mserver)).addHeartBeatNotificationListener(this.myListener, null, null);
            try {
                this.mserver.connect(connectorAddress);
            }
            catch (CommunicationException communicationException) {
                throw this.wrapToIO(communicationException);
            }
            if (this.logger.fineOn()) {
                this.logger.fine("connect", "The client has been connected with the ID " + this.connectionId);
            }
            this.serverConnection = new MBeanServerConnectionImpl();
            this.env = hashMap;
            this.connected = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.logger.fineOn()) {
            this.logger.fine("close", "The client " + this.connectionId + " is asked to be closed.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            this.connected = false;
            this.mserver.disconnect();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (!this.connected) {
                throw new IOException("Not connected.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.serverConnection;
        }
    }

    public MBeanServerConnection getMBeanServerConnection(Subject subject) throws IOException {
        if (subject == null) {
            return this.getMBeanServerConnection();
        }
        throw new UnsupportedOperationException("Sorry.");
    }

    public void addConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.connectionBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.connectionBroadcaster.removeNotificationListener(notificationListener);
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.connectionBroadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    public Object getWrapped() {
        return this.mserver;
    }

    private IOException wrapToIO(CommunicationException communicationException) {
        IOException iOException = new IOException(communicationException.toString());
        if (communicationException.getTargetException() != null) {
            EnvHelp.initCause(iOException, communicationException.getTargetException());
        } else {
            EnvHelp.initCause(iOException, communicationException);
        }
        return iOException;
    }

    private class HeartBeatNotifListener
    implements NotificationListener {
        private long sequenceCounter = 0L;

        private HeartBeatNotifListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            HeartBeatNotification heartBeatNotification = (HeartBeatNotification)notification;
            if ("jdmk.connector.heartbeat.connection.established".equals(heartBeatNotification.getType())) {
                JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.opened", this, JDMKClientConnector.this.connectionId, this.nextSequenceNumber(), "The client has been connected.", null);
                JDMKClientConnector.this.connectionBroadcaster.sendNotification(jMXConnectionNotification);
            } else if ("jdmk.connector.heartbeat.connection.lost".equals(heartBeatNotification.getType())) {
                JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.failed", this, JDMKClientConnector.this.connectionId, this.nextSequenceNumber(), "The connection to the server is lost.", null);
                JDMKClientConnector.this.connectionBroadcaster.sendNotification(jMXConnectionNotification);
            } else if ("jdmk.connector.heartbeat.connection.reestablished".equals(heartBeatNotification.getType())) {
                JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.opened", this, JDMKClientConnector.this.connectionId, this.nextSequenceNumber(), "The client has been connected.", null);
                JDMKClientConnector.this.connectionBroadcaster.sendNotification(jMXConnectionNotification);
            } else if (!"jdmk.connector.heartbeat.connection.retrying".equals(heartBeatNotification.getType()) && "jdmk.connector.heartbeat.connection.terminated".equals(heartBeatNotification.getType())) {
                JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.closed", this, JDMKClientConnector.this.connectionId, this.nextSequenceNumber(), "The client has been connected.", null);
                JDMKClientConnector.this.connectionBroadcaster.sendNotification(jMXConnectionNotification);
                if (JDMKClientConnector.this.terminated) {
                    try {
                        JDMKClientConnector.this.connectionBroadcaster.removeNotificationListener(JDMKClientConnector.this.myListener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private synchronized long nextSequenceNumber() {
            return this.sequenceCounter++;
        }
    }

    private class MBeanServerConnectionImpl
    implements MBeanServerConnection {
        private MBeanServerConnectionImpl() {
        }

        public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            try {
                return JDMKClientConnector.this.mserver.createMBean(string, objectName);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            try {
                return JDMKClientConnector.this.mserver.createMBean(string, objectName, objectName2);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            try {
                return JDMKClientConnector.this.mserver.createMBean(string, objectName, objectArray, stringArray);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            try {
                return JDMKClientConnector.this.mserver.createMBean(string, objectName, objectName2, objectArray, stringArray);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            try {
                JDMKClientConnector.this.mserver.unregisterMBean(objectName);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
            try {
                return JDMKClientConnector.this.mserver.getObjectInstance(objectName);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws IOException {
            try {
                return JDMKClientConnector.this.mserver.queryMBeans(objectName, queryExp);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public Set queryNames(ObjectName objectName, QueryExp queryExp) throws IOException {
            try {
                return JDMKClientConnector.this.mserver.queryNames(objectName, queryExp);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public boolean isRegistered(ObjectName objectName) throws IOException {
            try {
                return JDMKClientConnector.this.mserver.isRegistered(objectName);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public Integer getMBeanCount() throws IOException {
            try {
                return JDMKClientConnector.this.mserver.getMBeanCount();
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.getAttribute(objectName, string);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.getAttributes(objectName, stringArray);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            try {
                JDMKClientConnector.this.mserver.setAttribute(objectName, attribute);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.setAttributes(objectName, attributeList);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.invoke(objectName, string, objectArray, stringArray);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public String getDefaultDomain() throws IOException {
            try {
                return JDMKClientConnector.this.mserver.getDefaultDomain();
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public String[] getDomains() throws IOException {
            Set set = JDMKClientConnector.this.mserver.queryNames(null, null);
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = ((ObjectName)iterator.next()).getDomain();
                hashSet.add(string);
            }
            try {
                return hashSet.toArray(new String[hashSet.size()]);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
            try {
                JDMKClientConnector.this.nregistry.addNotificationListener(objectName, notificationListener, notificationFilter, object);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
            try {
                throw new UnsupportedOperationException("Sorry.");
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("Sorry.");
        }

        public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("Sorry.");
        }

        public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                JDMKClientConnector.this.nregistry.removeNotificationListener(objectName, notificationListener);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            throw new UnsupportedOperationException("Sorry.");
        }

        public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            try {
                return JDMKClientConnector.this.mserver.getMBeanInfo(objectName);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }

        public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, IOException {
            try {
                return JDMKClientConnector.this.mserver.isInstanceOf(objectName, string);
            }
            catch (CommunicationException communicationException) {
                throw JDMKClientConnector.this.wrapToIO(communicationException);
            }
        }
    }
}

