/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.HeartBeatNotification;
import com.sun.jdmk.internal.ClassLogger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

class HeartBeatClientHandlerImpl {
    private static String localClassName = "HeartBeatClientHandlerImpl";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.heartbeat", localClassName);
    private static final ClassLogger plogger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.heartbeat", "Ping");
    private int period = 10000;
    private int nretries = 6;
    private String heartbeatClientSessionId;
    private Long notifsClientId;
    private static long counter = 0L;
    private Ping ping;
    private Hashtable handbackTable = new Hashtable();
    private Hashtable filterTable = new Hashtable();
    private HeartBeatInternalClientHandler heartbeatConnector;
    private ClientNotificationDispatcher notifsConnector;

    public HeartBeatClientHandlerImpl(HeartBeatInternalClientHandler heartBeatInternalClientHandler, ClientNotificationDispatcher clientNotificationDispatcher) {
        if (heartBeatInternalClientHandler == null) {
            throw new IllegalArgumentException("heartbeatConnector cannot be null");
        }
        if (logger.finerOn()) {
            logger.finer("Constructor", "Create HeartBeatClientHandler.");
        }
        this.heartbeatConnector = heartBeatInternalClientHandler;
        this.notifsConnector = clientNotificationDispatcher;
    }

    public int getHeartBeatPeriod() {
        return this.period;
    }

    public synchronized void setHeartBeatPeriod(int n) {
        int n2 = this.period;
        this.period = n;
        if (this.heartbeatConnector.getRemoteMBeanServer().isConnected()) {
            if (n > 0 && n2 <= 0) {
                this.startPinging();
            } else if (n <= 0 && n2 > 0) {
                this.stopPinging(0, false);
            } else if (n > 0 && n2 > 0 && n != n2) {
                this.stopPinging(0, false);
                this.startPinging();
            }
        }
    }

    public int getHeartBeatRetries() {
        return this.nretries;
    }

    public synchronized void setHeartBeatRetries(int n) {
        this.nretries = n;
    }

    public synchronized void addHeartBeatNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Vector<Object> vector = (Vector<Object>)this.handbackTable.get(notificationListener);
        Vector<NotificationFilter> vector2 = (Vector<NotificationFilter>)this.filterTable.get(notificationListener);
        if (vector == null) {
            vector = new Vector<Object>();
            vector2 = new Vector<NotificationFilter>();
            this.handbackTable.put(notificationListener, vector);
            this.filterTable.put(notificationListener, vector2);
        }
        vector.addElement(object);
        vector2.addElement(notificationFilter);
    }

    public synchronized void removeHeartBeatNotificationListener(NotificationListener notificationListener) {
        Vector vector = (Vector)this.handbackTable.get(notificationListener);
        Vector vector2 = (Vector)this.filterTable.get(notificationListener);
        if (vector == null) {
            throw new IllegalArgumentException("Listener not found");
        }
        this.handbackTable.remove(notificationListener);
        this.filterTable.remove(notificationListener);
    }

    public synchronized void startPinging() {
        if (!(this.period <= 0 || this.ping != null && this.ping.isAlive())) {
            if (plogger.finerOn()) {
                plogger.finer("run", "Start pinging connector server...");
            }
            this.notifsClientId = this.notifsConnector != null ? this.notifsConnector.getNotificationClientId() : null;
            try {
                this.heartbeatClientSessionId = this.heartbeatConnector.pingHeartBeatServer(this.heartbeatClientSessionId, this.period, this.nretries, this.notifsClientId);
            }
            catch (Exception exception) {
                logger.warning("startPinging", "Failed to start pinging.", exception);
                return;
            }
            this.ping = new Ping();
            if (Thread.currentThread().getPriority() < 10) {
                this.ping.setPriority(Thread.currentThread().getPriority() + 1);
            }
            this.ping.start();
        }
    }

    public synchronized void stopPinging(int n, boolean bl) {
        if (this.ping != null) {
            if (plogger.finerOn()) {
                plogger.finer("terminate", "Stop pinging connector server...");
            }
            this.ping.terminate(n, bl);
            if (n == -1) {
                this.notifsClientId = null;
                this.heartbeatClientSessionId = null;
            }
            if (!this.ping.notifyingLost) {
                this.ping.interrupt();
            }
            this.ping = null;
        }
    }

    public void notifyConnectionEstablished() {
        if (logger.finerOn()) {
            logger.finer("notifyConnectionEstablished", "Send a Connection Established notification");
        }
        this.sendNotification(new HeartBeatNotification("jdmk.connector.heartbeat.connection.established", this.heartbeatConnector.getRemoteMBeanServer(), HeartBeatClientHandlerImpl.getSequenceNumber(), new Date().getTime(), "Notify Connection Established", this.heartbeatConnector.getRemoteMBeanServer().getMBeanServerAddress()));
    }

    public void notifyConnectionRetrying() {
        if (logger.finerOn()) {
            logger.finer("notifyConnectionRetrying", "Send a Connection Retrying notification");
        }
        this.sendNotification(new HeartBeatNotification("jdmk.connector.heartbeat.connection.retrying", this.heartbeatConnector.getRemoteMBeanServer(), HeartBeatClientHandlerImpl.getSequenceNumber(), new Date().getTime(), "Notify Connection Retrying", this.heartbeatConnector.getRemoteMBeanServer().getMBeanServerAddress()));
    }

    public void notifyConnectionLost() {
        if (logger.finerOn()) {
            logger.finer("notifyConnectionLost", "Send a Connection Lost notification");
        }
        this.sendNotification(new HeartBeatNotification("jdmk.connector.heartbeat.connection.lost", this.heartbeatConnector.getRemoteMBeanServer(), HeartBeatClientHandlerImpl.getSequenceNumber(), new Date().getTime(), "Notify Connection Lost", this.heartbeatConnector.getRemoteMBeanServer().getMBeanServerAddress()));
        this.heartbeatConnector.getRemoteMBeanServer().disconnect();
    }

    public void notifyConnectionReestablished() {
        if (logger.finerOn()) {
            logger.finer("notifyConnectionReestablished", "Send a Connection Reestablished notification");
        }
        this.sendNotification(new HeartBeatNotification("jdmk.connector.heartbeat.connection.reestablished", this.heartbeatConnector.getRemoteMBeanServer(), HeartBeatClientHandlerImpl.getSequenceNumber(), new Date().getTime(), "Notify Connection Reestablished", this.heartbeatConnector.getRemoteMBeanServer().getMBeanServerAddress()));
    }

    public void notifyConnectionTerminated() {
        if (logger.finerOn()) {
            logger.finer("notifyConnectionTerminated", "Send a Connection Terminated notification");
        }
        this.sendNotification(new HeartBeatNotification("jdmk.connector.heartbeat.connection.terminated", this.heartbeatConnector.getRemoteMBeanServer(), HeartBeatClientHandlerImpl.getSequenceNumber(), new Date().getTime(), "Notify Connection Terminated", this.heartbeatConnector.getRemoteMBeanServer().getMBeanServerAddress()));
    }

    private void sendNotification(Notification notification) {
        Enumeration enumeration = this.handbackTable.keys();
        while (enumeration.hasMoreElements()) {
            NotificationListener notificationListener = (NotificationListener)enumeration.nextElement();
            Vector vector = (Vector)this.handbackTable.get(notificationListener);
            Vector vector2 = (Vector)this.filterTable.get(notificationListener);
            Enumeration enumeration2 = vector2.elements();
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                Object e = enumeration3.nextElement();
                NotificationFilter notificationFilter = (NotificationFilter)enumeration2.nextElement();
                if (notificationFilter != null && (notificationFilter == null || !notificationFilter.isNotificationEnabled(notification))) continue;
                notificationListener.handleNotification(notification, e);
            }
        }
    }

    private static long getSequenceNumber() {
        if (counter == Long.MAX_VALUE) {
            counter = 0L;
        }
        return counter++;
    }

    private class Ping
    extends Thread {
        public volatile boolean notifyingLost = false;
        private int nretry = 0;
        private long sendingTime = 0L;
        private long responseTime = 0L;
        private long receivingTime = 0L;
        private boolean toBeTerminated = false;
        private String heartbeatServerSessionId = null;

        private Ping() {
        }

        public void run() {
            if (HeartBeatClientHandlerImpl.this.period > 0) {
                try {
                    Ping.sleep(HeartBeatClientHandlerImpl.this.period);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            while (!this.toBeTerminated && HeartBeatClientHandlerImpl.this.period > 0) {
                block18: {
                    this.sendingTime = 0L;
                    this.receivingTime = 0L;
                    this.responseTime = 0L;
                    if (HeartBeatClientHandlerImpl.this.notifsConnector != null) {
                        HeartBeatClientHandlerImpl.this.notifsClientId = HeartBeatClientHandlerImpl.this.notifsConnector.getNotificationClientId();
                    } else {
                        HeartBeatClientHandlerImpl.this.notifsClientId = null;
                    }
                    this.sendingTime = System.currentTimeMillis();
                    try {
                        if (this.toBeTerminated) break;
                        this.heartbeatServerSessionId = HeartBeatClientHandlerImpl.this.heartbeatConnector.pingHeartBeatServer(HeartBeatClientHandlerImpl.this.heartbeatClientSessionId, HeartBeatClientHandlerImpl.this.period, HeartBeatClientHandlerImpl.this.nretries, HeartBeatClientHandlerImpl.this.notifsClientId);
                        if (HeartBeatClientHandlerImpl.this.heartbeatClientSessionId == null) {
                            if (this.toBeTerminated) break;
                            HeartBeatClientHandlerImpl.this.heartbeatClientSessionId = this.heartbeatServerSessionId;
                        } else if (this.heartbeatServerSessionId == null) {
                            if (this.toBeTerminated) break;
                            this.notifyingLost = true;
                            HeartBeatClientHandlerImpl.this.notifyConnectionLost();
                            this.notifyingLost = false;
                            break;
                        }
                        if (this.nretry <= 0) break block18;
                        if (this.toBeTerminated) break;
                        this.nretry = 0;
                        HeartBeatClientHandlerImpl.this.notifyConnectionReestablished();
                    }
                    catch (Exception exception) {
                        boolean bl = true;
                        if (!bl) break block18;
                        if (HeartBeatClientHandlerImpl.this.nretries != 0) {
                            ++this.nretry;
                            if (this.nretry == 1) {
                                if (this.toBeTerminated) break;
                                HeartBeatClientHandlerImpl.this.notifyConnectionRetrying();
                            } else if (this.nretry > HeartBeatClientHandlerImpl.this.nretries) {
                                if (this.toBeTerminated) break;
                                this.notifyingLost = true;
                                HeartBeatClientHandlerImpl.this.notifyConnectionLost();
                                this.notifyingLost = false;
                                break;
                            }
                        }
                        if (this.toBeTerminated) break;
                        this.notifyingLost = true;
                        HeartBeatClientHandlerImpl.this.notifyConnectionLost();
                        this.notifyingLost = false;
                        break;
                    }
                }
                this.receivingTime = System.currentTimeMillis();
                this.responseTime = this.receivingTime - this.sendingTime;
                if (this.responseTime >= (long)HeartBeatClientHandlerImpl.this.period) continue;
                if (this.toBeTerminated) break;
                if (logger.finerOn()) {
                    plogger.finer("run", "Next heartbeat ping will be sent in " + ((long)HeartBeatClientHandlerImpl.this.period - this.responseTime) + " ms.");
                    plogger.finer("run", "Session Id = " + HeartBeatClientHandlerImpl.this.heartbeatClientSessionId);
                }
                try {
                    Ping.sleep((long)HeartBeatClientHandlerImpl.this.period - this.responseTime);
                }
                catch (InterruptedException interruptedException) {
                    if (!this.toBeTerminated) continue;
                    break;
                }
            }
        }

        public void terminate(int n, boolean bl) {
            this.toBeTerminated = true;
            if (!bl && !this.notifyingLost) {
                if (HeartBeatClientHandlerImpl.this.notifsConnector != null) {
                    HeartBeatClientHandlerImpl.this.notifsClientId = HeartBeatClientHandlerImpl.this.notifsConnector.getNotificationClientId();
                } else {
                    HeartBeatClientHandlerImpl.this.notifsClientId = null;
                }
                try {
                    this.heartbeatServerSessionId = HeartBeatClientHandlerImpl.this.heartbeatConnector.pingHeartBeatServer(HeartBeatClientHandlerImpl.this.heartbeatClientSessionId, n, HeartBeatClientHandlerImpl.this.nretries, HeartBeatClientHandlerImpl.this.notifsClientId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

