/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.optimize.evaluation.value.DoubleValue;
import proguard.optimize.evaluation.value.FloatValue;
import proguard.optimize.evaluation.value.InstructionOffsetValue;
import proguard.optimize.evaluation.value.IntegerValue;
import proguard.optimize.evaluation.value.LongValue;
import proguard.optimize.evaluation.value.ReferenceValue;
import proguard.optimize.evaluation.value.Value;

class Variables {
    protected Value[] values;
    protected int size;

    public Variables(int n) {
        this.values = new Value[n];
        this.size = n;
    }

    public Variables(Variables variables) {
        this(variables.size);
        this.initialize(variables);
    }

    public void reset(int n) {
        if (n > this.values.length) {
            this.values = new Value[n];
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = null;
            }
        }
        this.size = n;
    }

    public void initialize(Variables variables) {
        if (this.size < variables.size) {
            throw new IllegalArgumentException("Variable frame is too small [" + this.size + "] compared to other frame [" + variables.size + "]");
        }
        System.arraycopy(variables.values, 0, this.values, 0, variables.size);
    }

    public boolean generalize(Variables variables) {
        if (this.size != variables.size) {
            throw new IllegalArgumentException("Variable frames have different sizes [" + this.size + "] and [" + variables.size + "]");
        }
        boolean bl = false;
        for (int i = 0; i < this.size; ++i) {
            Value value = variables.values[i];
            if (value == null) continue;
            Value value2 = this.values[i];
            if (value2 != null && value2.computationalType() == value.computationalType()) {
                value = value2.generalize(value);
                bl = bl || !value.equals(value2);
            }
            this.values[i] = value;
        }
        return bl;
    }

    public int size() {
        return this.size;
    }

    public void store(int n, Value value) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Variable index [" + n + "] out of bounds [" + this.size + "]");
        }
        this.values[n] = value;
    }

    public Value load(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Variable index [" + n + "] out of bounds [" + this.size + "]");
        }
        return this.values[n];
    }

    public IntegerValue iload(int n) {
        return this.load(n).integerValue();
    }

    public LongValue lload(int n) {
        return this.load(n).longValue();
    }

    public FloatValue fload(int n) {
        return this.load(n).floatValue();
    }

    public DoubleValue dload(int n) {
        return this.load(n).doubleValue();
    }

    public ReferenceValue aload(int n) {
        return this.load(n).referenceValue();
    }

    public InstructionOffsetValue oload(int n) {
        return this.load(n).instructionOffsetValue();
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Variables variables = (Variables)object;
        if (this.size != variables.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            Value value = this.values[i];
            Value value2 = variables.values[i];
            if (value == null || value2 == null || value.computationalType() != value2.computationalType() || value.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.size;
        for (int i = 0; i < this.size; ++i) {
            Value value = this.values[i];
            if (value == null) continue;
            n ^= value.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            Value value = this.values[i];
            stringBuffer = stringBuffer.append('[').append(value == null ? "empty" : value.toString()).append(']');
        }
        return stringBuffer.toString();
    }
}

