/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class UnsignedByteType
extends BaseNumberDataType {
    static final short MIN_VALUE = 0;
    static final short MAX_VALUE = 255;
    private static final long serialVersionUID = 2501005806335170795L;

    public int getJdbcType() {
        return -6;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Short";
    }

    public int getPrecision() {
        return String.valueOf(255).length();
    }

    public int getColumnDisplaySize() {
        return String.valueOf(255).length();
    }

    public String toString() {
        return "unsignedbyte";
    }

    public boolean accepts(Object value) {
        if (value instanceof Number) {
            short s = ((Number)value).shortValue();
            try {
                this.assertValidUnsignedByte(s);
            }
            catch (AxionException e) {
                return false;
            }
            return true;
        }
        return super.accepts(value);
    }

    public Object convert(Object value) throws AxionException {
        if (value instanceof Number) {
            short s = ((Number)value).shortValue();
            this.assertValidUnsignedByte(s);
            return new Short(s);
        }
        if (value instanceof String) {
            try {
                Short sval = new Short(new BigDecimal(value.toString().trim()).shortValue());
                this.assertValidUnsignedByte(sval);
                return sval;
            }
            catch (NumberFormatException e) {
                throw new AxionException(22018);
            }
        }
        return super.convert(value);
    }

    public Object successor(Object value) throws IllegalArgumentException {
        short v = (Short)value;
        try {
            this.assertValidUnsignedByte(v);
        }
        catch (AxionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (v == 255) {
            return value;
        }
        v = (short)(v + 1);
        return new Short(v);
    }

    public Object read(DataInput in) throws IOException {
        short value = this.toShort(in.readByte());
        if (0 == value && !in.readBoolean()) {
            return null;
        }
        return new Short(value);
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeByte(this.fromShort((short)0));
            out.writeBoolean(false);
        } else {
            try {
                short val = (Short)this.convert(value);
                out.writeByte(this.fromShort(val));
                if (0 == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new UnsignedByteType();
    }

    public boolean isUnsigned() {
        return true;
    }

    private final short toShort(byte value) {
        return (short)(value & 0xFF);
    }

    private final byte fromShort(short value) {
        return (byte)(value & 0xFF);
    }

    private final void assertValidUnsignedByte(short value) throws AxionException {
        if (value > 255 || value < 0) {
            throw new AxionException(22003);
        }
    }
}

