/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.TimestampType;

public class TimeType
extends TimestampType {
    static final long INCREMENT_MS = 1L;
    static final long serialVersionUID = -1850471442550601883L;
    private static final Object LOCK_TIME_PARSING = new Object();
    private static final Object LOCK_TIME_FORMATTING = new Object();
    private static final DateFormat[] TIME_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", LOCALE), new SimpleDateFormat("yyyy-MM-dd", LOCALE), new SimpleDateFormat("MM-dd-yyyy", LOCALE), new SimpleDateFormat("HH:mm:ss", LOCALE), DateFormat.getTimeInstance(3, LOCALE)};
    private static final DateFormat ISO_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static TimeZone TIME_ZONE;

    public static TimeZone getTimeZone() {
        return TIME_ZONE;
    }

    public static long normalizeTime(long rawTimeMillis) {
        int dstOffset = TIME_ZONE.inDaylightTime(new Date(rawTimeMillis)) ? TIME_ZONE.getDSTSavings() : 0;
        return rawTimeMillis < 86400000L ? rawTimeMillis : rawTimeMillis % 86400000L + (long)dstOffset;
    }

    public boolean accepts(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof Date) {
            return true;
        }
        if (value instanceof java.sql.Date) {
            return true;
        }
        return value instanceof Time;
    }

    private Time getNormalizedTime(long time) {
        Time ret = null;
        ret = new Time(TimeType.normalizeTime(time));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time convertToTime(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Number) {
            return this.getNormalizedTime(((Number)value).longValue());
        }
        if (value instanceof Timestamp) {
            return this.getNormalizedTime(((Timestamp)value).getTime());
        }
        if (value instanceof java.sql.Date) {
            return this.getNormalizedTime(((java.sql.Date)value).getTime());
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof Date) {
            return this.getNormalizedTime(((Date)value).getTime());
        }
        if (value instanceof String) {
            Date dVal = null;
            for (int i = 0; dVal == null && i < TIME_PARSING_FORMATS.length; ++i) {
                Object object = LOCK_TIME_PARSING;
                synchronized (object) {
                    dVal = TIME_PARSING_FORMATS[i].parse((String)value, new ParsePosition(0));
                    continue;
                }
            }
            if (dVal == null) {
                throw new AxionException(22007);
            }
            return this.getNormalizedTime(dVal.getTime());
        }
        throw new AxionException(22007);
    }

    public Object convert(Object value) throws AxionException {
        if (value instanceof Time) {
            return value;
        }
        return this.convertToTime(value);
    }

    public int getColumnDisplaySize() {
        return 8;
    }

    public int getPrecision() {
        return 8;
    }

    public int getJdbcType() {
        return 92;
    }

    public DataType makeNewInstance() {
        return new TimeType();
    }

    public Object successor(Object value) throws IllegalArgumentException {
        try {
            return new Time(((Time)this.convert(value)).getTime() + 1L);
        }
        catch (AxionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public BigDecimal toBigDecimal(Object value) throws AxionException {
        java.sql.Date dval = (java.sql.Date)this.convert(value);
        Long time = new Long(dval.getTime());
        return super.toBigDecimal(time);
    }

    public java.sql.Date toDate(Object value) throws AxionException {
        throw new AxionException("Can't convert " + this.toString() + " to Date.");
    }

    public String toString() {
        return "time";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object value) throws AxionException {
        Time tval = this.toTime(value);
        if (null == tval) {
            return null;
        }
        Object object = LOCK_TIME_FORMATTING;
        synchronized (object) {
            return ISO_TIME_FORMAT.format(tval).toString();
        }
    }

    public Time toTime(Object value) throws AxionException {
        return value instanceof Time ? (Time)value : this.convertToTime(value);
    }

    public Timestamp toTimestamp(Object value) throws AxionException {
        return new Timestamp(this.convertToTime(value).getTime());
    }

    public Object read(DataInput in) throws IOException {
        Time result = null;
        int nanos = in.readInt();
        if (Integer.MIN_VALUE != nanos) {
            long millis = in.readLong();
            result = new Time(millis);
        }
        return result;
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeInt(Integer.MIN_VALUE);
        } else {
            try {
                Time val = (Time)this.convert(value);
                out.writeInt(0);
                out.writeLong(val.getTime());
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimeZone(String id) {
        TimeZone tZone = TimeZone.getTimeZone(id);
        if (tZone != null) {
            Object object = LOCK_TIME_PARSING;
            synchronized (object) {
                TIME_ZONE = tZone;
                for (int i = 0; i < TIME_PARSING_FORMATS.length; ++i) {
                    TIME_PARSING_FORMATS[i].setTimeZone(tZone);
                }
            }
            object = LOCK_TIME_FORMATTING;
            synchronized (object) {
                ISO_TIME_FORMAT.setTimeZone(tZone);
            }
        }
    }

    static {
        for (int i = 0; i < TIME_PARSING_FORMATS.length; ++i) {
            TIME_PARSING_FORMATS[i].setLenient(false);
        }
        TIME_ZONE = TimeZone.getDefault();
    }
}

