/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.axiondb.AxionException;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.types.LobSource;

public class FileOffsetLobSource
implements LobSource {
    private BufferedDataInputStream _in = null;
    private long _offset = -1L;
    private int _length = -1;
    private byte[] _data = null;

    public FileOffsetLobSource(BufferedDataInputStream in, long offset, int length) {
        this._in = in;
        this._offset = offset;
        this._length = length;
    }

    public long length() throws AxionException {
        return this._length;
    }

    public void truncate(long length) throws AxionException {
        throw new AxionException("Can't truncate FileOffsetLobs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws AxionException {
        if (null == this._data) {
            this._data = new byte[this._length];
            try {
                BufferedDataInputStream bufferedDataInputStream = this._in;
                synchronized (bufferedDataInputStream) {
                    this._in.seek(this._offset);
                    this._in.read(this._data);
                }
            }
            catch (IOException e) {
                throw new AxionException(e);
            }
        }
        return new ByteArrayInputStream(this._data);
    }

    public OutputStream setOutputStream(long pos) throws AxionException {
        throw new AxionException("Can't setOutputStream in FileOffsetLobs");
    }
}

