/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.types.FileLobSource;
import org.axiondb.types.LobLocator;
import org.axiondb.types.LobSource;

public class FileLobLocator
implements LobLocator {
    private transient String _directoryName = null;
    private transient String _fileName = null;

    public FileLobLocator(File file) {
        this._directoryName = file.getParentFile().getName();
        this._fileName = file.getName();
    }

    public FileLobLocator(String directory, String file) {
        this._directoryName = directory;
        this._fileName = file;
    }

    public String getDirectoryName() {
        return this._directoryName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public File getFile(File parentDir) {
        return new File(new File(parentDir, this._directoryName), this._fileName);
    }

    public LobSource getLobSource(File parentDir, BufferedDataInputStream in) {
        return new FileLobSource(this.getFile(parentDir));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("dir=");
        buf.append(this.getDirectoryName());
        buf.append(";file=");
        buf.append(this.getFileName());
        return buf.toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this._directoryName);
        out.writeUTF(this._fileName);
    }

    public LobLocator read(DataInput in) throws IOException {
        return new FileLobLocator(in.readUTF(), in.readUTF());
    }
}

