/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseDataType;
import org.axiondb.types.CLOBType;

public class CharacterType
extends BaseDataType
implements DataType.NonFixedPrecision {
    private int _size = 1;
    private static final long serialVersionUID = 7980560473106205818L;
    private static final transient char PAD_CHAR = ' ';
    private static final transient Map PAD_MAP = new HashMap();

    public CharacterType() {
        this(1);
    }

    public CharacterType(int size) {
        this._size = size;
    }

    public int getJdbcType() {
        return 1;
    }

    public String getPreferredValueClassName() {
        return "java.lang.String";
    }

    public final int getPrecision() {
        return this._size;
    }

    public int getColumnDisplaySize() {
        return this.getPrecision();
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public String toString() {
        return "character(" + this._size + ")";
    }

    public byte[] toByteArray(Object value) throws AxionException {
        return this.toString(value).getBytes();
    }

    public boolean accepts(Object value) {
        return true;
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        return (String)value + "\u0000";
    }

    public Object convert(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return this.process((String)value);
        }
        if (value instanceof char[]) {
            return this.process(new String((char[])value));
        }
        if (value instanceof byte[]) {
            return this.process(new String((byte[])value));
        }
        if (value instanceof Clob) {
            return this.process(new CLOBType().toString(value));
        }
        if (value instanceof Blob) {
            try {
                return this.process(new String(((Blob)value).getBytes(1L, (int)((Blob)value).length())));
            }
            catch (Exception e) {
                throw new AxionException(e);
            }
        }
        return this.process(value.toString());
    }

    public Object read(DataInput in) throws IOException {
        String val = in.readUTF();
        if ("null".equals(val) && !in.readBoolean()) {
            return null;
        }
        return val;
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeUTF("null");
            out.writeBoolean(false);
        } else if ("null".equals(value)) {
            out.writeUTF("null");
            out.writeBoolean(true);
        } else {
            out.writeUTF(value.toString());
        }
    }

    public DataType makeNewInstance() {
        return new CharacterType();
    }

    public int compare(Object a, Object b) {
        return ((String)a).compareTo((String)b);
    }

    public void setPrecision(int newSize) {
        this._size = newSize;
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public short getSearchableCode() {
        return 3;
    }

    protected Comparator getComparator() {
        return this;
    }

    protected String process(String value) throws AxionException {
        return this.padOutput(this.truncateIfLegal(value));
    }

    protected final String truncateIfLegal(String source) throws AxionException {
        if (source.length() <= this._size) {
            return source;
        }
        String trimmedSource = this.rightTrim(source);
        if (trimmedSource.length() <= this._size) {
            return trimmedSource;
        }
        throw new AxionException(22001);
    }

    protected final String rightTrim(String source) {
        int i;
        if (source.length() <= this._size) {
            return source;
        }
        int trimSourceLen = source.length();
        int len = trimSourceLen - 1;
        char trimChar = ' ';
        for (i = len; i > 0 && source.charAt(i) <= trimChar; --i) {
        }
        return i == len ? source : source.substring(0, i + 1);
    }

    private final String padOutput(String source) {
        if (source.length() == this._size) {
            return source;
        }
        return source.concat(this.getOrCreatePadTemplate(this._size - source.length()));
    }

    private final String getOrCreatePadTemplate(int size) {
        String padTemplate = (String)PAD_MAP.get(Integer.toString(size));
        if (padTemplate == null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this._size; ++i) {
                buf.append(' ');
            }
            buf.setLength(size);
            padTemplate = buf.toString();
            PAD_MAP.put(Integer.toString(size), padTemplate);
        }
        return padTemplate;
    }
}

