/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.axiondb.AxionException;
import org.axiondb.jdbc.ConnectionFactory;
import org.axiondb.util.ExceptionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxionDataSource
extends ConnectionFactory
implements DataSource {
    private int _loginTimeout = 0;
    private PrintWriter _logWriter = null;
    private String _connectString = null;

    public AxionDataSource(String connectString) {
        this._connectString = connectString;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isValidConnectString(this._connectString)) {
            try {
                return this.createConnection(this._connectString);
            }
            catch (AxionException e) {
                throw ExceptionConverter.convert(e);
            }
        }
        throw new SQLException("Can't create a Connection for " + this._connectString);
    }

    @Override
    public Connection getConnection(String uname, String passwd) throws SQLException {
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() {
        return this._loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this._loginTimeout = seconds;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter log) {
        this._logWriter = log;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Unsupported.");
    }
}

