/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.types.StringType;

public class RPadFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new StringType();
    private static final DataType ARG_TYPE = new IntegerType();

    public RPadFunction() {
        super("RPAD");
    }

    public ConcreteFunction makeNewInstance() {
        return new RPadFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = this.getArgument(0).evaluate(row);
        Object val1 = this.getArgument(1).evaluate(row);
        Object val3 = this.getArgument(2).evaluate(row);
        String pad = (String)RETURN_TYPE.convert(val3);
        String s1 = (String)RETURN_TYPE.convert(val);
        Integer length = (Integer)ARG_TYPE.convert(val1);
        if (pad == null || s1.length() >= length) {
            return s1;
        }
        int len = length - s1.length();
        for (int i = 0; i < len; ++i) {
            s1 = s1 + pad;
        }
        return s1;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 3;
    }
}

