/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BooleanType;

public class ExistsFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new BooleanType();

    public ExistsFunction() {
        super("EXISTS");
    }

    public ConcreteFunction makeNewInstance() {
        return new ExistsFunction();
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        if (sel instanceof SelectCommand) {
            RowIterator iter = (RowIterator)sel.evaluate(row);
            if (iter.hasNext()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

