/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.sql.Timestamp;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;
import org.axiondb.types.TimestampType;
import org.axiondb.util.DateTimeUtils;

public class DateToCharFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new StringType();
    private static final DataType ARG1_TYPE = new TimestampType();
    private static final DataType ARG2_TYPE = new StringType();

    public DateToCharFunction() {
        super("DATETOCHAR");
    }

    public ConcreteFunction makeNewInstance() {
        return new DateToCharFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Timestamp timestamp = null;
        String formatStr = null;
        Object arg2 = this.getArgument(1).evaluate(row);
        if (null == arg2) {
            throw new AxionException("DateToChar cannot accept a null format string.");
        }
        formatStr = (String)ARG2_TYPE.convert(arg2);
        Object arg1 = this.getArgument(0).evaluate(row);
        if (null == arg1) {
            return null;
        }
        timestamp = (Timestamp)ARG1_TYPE.convert(arg1);
        return DateTimeUtils.convertToChar(timestamp, formatStr);
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 2;
    }
}

