/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.axiondb.BaseSelectable;
import org.axiondb.DataType;
import org.axiondb.Selectable;
import org.axiondb.VariableContext;
import org.axiondb.functions.ConcreteFunction;

public abstract class BaseFunction
extends BaseSelectable
implements ConcreteFunction {
    private List _args = new ArrayList(2);

    public BaseFunction(String name) {
        this.setName(name);
    }

    public BaseFunction(String name, List args) {
        this.setName(name);
        this._args = args;
    }

    public void addArgument(Selectable arg) {
        this._args.add(arg);
    }

    public Selectable getArgument(int i) {
        return (Selectable)this._args.get(i);
    }

    public int getArgumentCount() {
        return this._args.size();
    }

    public abstract DataType getDataType();

    public abstract boolean isValid();

    public void setArgument(int i, Selectable arg) {
        this._args.set(i, arg);
    }

    public void setVariableContext(VariableContext context) {
        for (Selectable sel : this._args) {
            if (null == sel) continue;
            sel.setVariableContext(context);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        if (!this._args.isEmpty()) {
            buf.append("(");
            Iterator iter = this._args.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
                if (!iter.hasNext()) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (null != this.getAlias()) {
            buf.append(" AS ");
            buf.append(this.getAlias());
        }
        return buf.toString();
    }
}

