/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntList;
import org.axiondb.AxionException;
import org.axiondb.OrderNode;
import org.axiondb.Row;
import org.axiondb.RowComparator;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.engine.rowiterators.DelegatingRowIterator;
import org.axiondb.engine.rowiterators.LazyRowRowIterator;
import org.axiondb.engine.rowiterators.ListRowIterator;
import org.axiondb.util.ComparatorChain;

public abstract class SortedRowIterator
extends DelegatingRowIterator {
    protected String _keyString = "";
    protected RowIterator _rowIter = null;

    protected SortedRowIterator() {
        super(null);
    }

    public String toString() {
        return "SortedRowIterator (key=" + this._keyString + ")";
    }

    protected static final ComparatorChain buildComparatorChain(List orderNodes, RowDecorator rowDecorator) {
        ComparatorChain comparator = new ComparatorChain();
        int I = orderNodes.size();
        for (int i = 0; i < I; ++i) {
            OrderNode node = (OrderNode)orderNodes.get(i);
            if (node.isDescending()) {
                comparator.setReverseSort(i);
            }
            comparator.addComparator(new RowComparator(node.getSelectable(), rowDecorator));
        }
        return comparator;
    }

    public static class MutableMergeSort
    extends SortedRowIterator {
        public MutableMergeSort(RowSource source, RowIterator unsortedRows, Comparator comparator) throws AxionException {
            IntList ids = this.getSortedRowIds(unsortedRows, comparator);
            this.setDelegate(new LazyRowRowIterator(source, ids.listIterator(), ids.size()));
        }

        public MutableMergeSort(RowSource source, RowIterator unsortedRows, List orderNodes, RowDecorator rowDecorator) throws AxionException {
            this(source, unsortedRows, MutableMergeSort.buildComparatorChain(orderNodes, rowDecorator));
            this._keyString = orderNodes.toString();
        }

        public void remove() throws AxionException {
            this.getDelegate().remove();
        }

        public void set(Row row) throws AxionException {
            this.getDelegate().set(row);
        }

        private IntList getSortedRowIds(RowIterator unsortedRows, Comparator comparator) throws AxionException {
            ArrayList<Row> list = new ArrayList<Row>();
            while (unsortedRows.hasNext()) {
                list.add(unsortedRows.next());
            }
            Object[] rowArry = list.toArray();
            Arrays.sort(rowArry, comparator);
            ArrayIntList ids = new ArrayIntList(rowArry.length);
            for (int j = 0; j < rowArry.length; ++j) {
                ids.add(((Row)rowArry[j]).getIdentifier());
            }
            return ids;
        }
    }

    public static class MergeSort
    extends SortedRowIterator {
        public MergeSort(RowIterator unsortedRows, Comparator comparator) throws AxionException {
            List sortedList = this.getSortedRowList(unsortedRows, comparator);
            this.setDelegate(new ListRowIterator(sortedList));
        }

        public MergeSort(RowIterator unsortedRows, List orderNodes, RowDecorator rowDecorator) throws AxionException {
            this(unsortedRows, MergeSort.buildComparatorChain(orderNodes, rowDecorator));
            this._keyString = orderNodes.toString();
        }

        private List getSortedRowList(RowIterator unsortedRows, Comparator comparator) throws AxionException {
            ArrayList<Row> list = new ArrayList<Row>();
            while (unsortedRows.hasNext()) {
                list.add(unsortedRows.next());
            }
            Collections.sort(list, comparator);
            return list;
        }
    }
}

