/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import org.axiondb.AxionException;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.Table;
import org.axiondb.engine.rowiterators.MutableIndexedRowIterator;

public class ChangingIndexedRowIterator
implements MutableIndexedRowIterator {
    private RowIterator _delegate;
    private Function _function;
    private Index _index;
    private Table _table;

    public ChangingIndexedRowIterator(Index index, Table table, Function fn) throws AxionException {
        this._index = index;
        this._table = table;
        this._function = fn;
        this.reset();
    }

    public void add(Row row) throws AxionException {
        this.assertIndexSet();
        this._delegate.add(row);
    }

    public Row current() {
        this.assertIndexSet();
        return this._delegate.current();
    }

    public int currentIndex() {
        this.assertIndexSet();
        return this._delegate.currentIndex();
    }

    public Row first() throws AxionException {
        this.assertIndexSet();
        return this._delegate.first();
    }

    public boolean hasCurrent() {
        if (this.indexSet()) {
            return this._delegate.hasCurrent();
        }
        return false;
    }

    public boolean hasNext() {
        if (this.indexSet()) {
            return this._delegate.hasNext();
        }
        return false;
    }

    public boolean hasPrevious() {
        if (this.indexSet()) {
            return this._delegate.hasPrevious();
        }
        return false;
    }

    public final boolean indexSet() {
        return this._delegate != null;
    }

    public boolean isEmpty() {
        return !this.hasNext() && !this.hasPrevious() && !this.hasCurrent();
    }

    public Row last() throws AxionException {
        this.assertIndexSet();
        return this._delegate.last();
    }

    public Row next() throws AxionException {
        this.assertIndexSet();
        return this._delegate.next();
    }

    public int next(int count) throws AxionException {
        this.assertIndexSet();
        return this._delegate.next(count);
    }

    public int nextIndex() {
        this.assertIndexSet();
        return this._delegate.nextIndex();
    }

    public Row peekNext() throws AxionException {
        this.assertIndexSet();
        return this._delegate.peekNext();
    }

    public Row peekPrevious() throws AxionException {
        this.assertIndexSet();
        return this._delegate.peekPrevious();
    }

    public Row previous() throws AxionException {
        this.assertIndexSet();
        return this._delegate.previous();
    }

    public int previous(int count) throws AxionException {
        this.assertIndexSet();
        return this._delegate.previous(count);
    }

    public int previousIndex() {
        this.assertIndexSet();
        return this._delegate.previousIndex();
    }

    public void remove() throws AxionException {
        this.assertIndexSet();
        this._delegate.remove();
    }

    public void removeIndexKey() throws AxionException {
        this._delegate = null;
    }

    public void reset() throws AxionException {
        if (this.indexSet()) {
            this._delegate.reset();
        }
    }

    public void set(Row row) throws AxionException {
        this.assertIndexSet();
        this._delegate.set(row);
    }

    public void setIndexKey(Object value) throws AxionException {
        this._delegate = this._index.getRowIterator(this._table, this._function, value);
        this.reset();
    }

    public int size() throws AxionException {
        this.assertIndexSet();
        return this._delegate.size();
    }

    public String toString() {
        return "ChangingIndexed(index=" + this._index.getName() + ";table=" + this._table.getName() + ";condition=" + this._function + ")";
    }

    private void assertIndexSet() {
        if (!this.indexSet()) {
            throw new IllegalStateException("Index not set yet");
        }
    }
}

