/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.Index;
import org.axiondb.IndexFactory;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.CreateCommand;

public class CreateIndexCommand
extends CreateCommand {
    private boolean _unique = false;
    private String _type;
    private TableIdentifier _table;
    private List _columns = new ArrayList(2);

    public TableIdentifier getTable() {
        return this._table;
    }

    public void setTable(TableIdentifier table) {
        this._table = table;
    }

    public void setTable(String tableName) {
        this._table = new TableIdentifier(tableName);
    }

    public void addColumn(String name) {
        this._columns.add(new ColumnIdentifier(name));
    }

    public void addColumn(ColumnIdentifier col) {
        this._columns.add(col);
    }

    public ColumnIdentifier getColumn(int i) {
        return (ColumnIdentifier)this._columns.get(i);
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public void setUnique(boolean unique) {
        this._unique = unique;
    }

    public boolean isUnique() {
        return this._unique;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (!this.isIfNotExists() || !db.hasIndex(this.getObjectName())) {
            if (this.getColumnCount() > 1) {
                throw new AxionException("Multi-column indices are not supported yet.");
            }
            Table table = db.getTable(this.getTable());
            if (null == table) {
                throw new AxionException("Table " + this.getTable() + " not found.");
            }
            if (this.getObjectName().startsWith("SYS")) {
                throw new AxionException("Cannot create user index with a name starting with SYS - reserved for internally-generated indexes.");
            }
            String columnName = this.getColumn(0).getName();
            Column column = table.getColumn(columnName);
            Index index = null;
            IndexFactory factory = db.getIndexFactory(null == this._type ? "default" : this._type);
            if (null == factory) {
                throw new AxionException("Index type \"" + this._type + "\" not recognized.");
            }
            index = factory.makeNewInstance(this.getObjectName(), column, this._unique, db.getDBDirectory() == null);
            db.addIndex(index, table, true);
        }
        return false;
    }
}

