/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Table;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.jdbc.AxionResultSet;

public abstract class ConstraintCommand
extends BaseAxionCommand {
    private String _tableName;

    public ConstraintCommand(String tableName) {
        this.setTableName(tableName);
    }

    public void setTableName(String name) {
        this._tableName = name;
    }

    public String getTableName() {
        return this._tableName;
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (null == this._tableName) {
            throw new AxionException("Table name must not be null.");
        }
        Table table = db.getTable(this._tableName);
        if (null == table) {
            throw new AxionException("Table " + this._tableName + " not found.");
        }
        this.execute(db, table);
        db.tableAltered(table);
        return false;
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use execute.");
    }

    public int executeUpdate(Database database) throws AxionException {
        this.execute(database);
        return 0;
    }

    protected abstract void execute(Database var1, Table var2) throws AxionException;
}

