/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.File;
import java.util.Properties;
import org.axiondb.AxionException;
import org.axiondb.Table;
import org.axiondb.TableFactory;
import org.axiondb.engine.BaseDatabase;
import org.axiondb.engine.MemoryTableFactory;
import org.axiondb.engine.tables.MemoryTable;

public class MemoryDatabase
extends BaseDatabase {
    private static final TableFactory DEFAULT_TABLE_FACTORY = new MemoryTableFactory();

    public MemoryDatabase() throws AxionException {
        this(null, null);
    }

    public MemoryDatabase(String name) throws AxionException {
        this(name, null);
    }

    public MemoryDatabase(String name, Properties props) throws AxionException {
        super(name);
        this.createMetaDataTables();
        if (null != props) {
            this.loadProperties(props);
        } else {
            this.loadProperties(MemoryDatabase.getBaseProperties());
        }
    }

    public TableFactory getTableFactory(String name) {
        if (null == name || "default".equals(name)) {
            return DEFAULT_TABLE_FACTORY;
        }
        return super.getTableFactory(name);
    }

    public File getDBDirectory() {
        return null;
    }

    protected Table createSystemTable(String name) {
        return new MemoryTable(name, "SYSTEM TABLE");
    }
}

