/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.constraints;

import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.constraints.BaseConstraint;
import org.axiondb.engine.visitors.ResolveSelectableVisitor;
import org.axiondb.event.RowEvent;

public class CheckConstraint
extends BaseConstraint {
    private Selectable _condition;
    private static final long serialVersionUID = 6322188199298311548L;

    public CheckConstraint(String name) {
        super(name, "CHECK");
    }

    public void setCondition(Selectable where) {
        this._condition = where;
    }

    public Selectable getCondition() {
        return this._condition;
    }

    public void resolve(Database db, TableIdentifier table) throws AxionException {
        ResolveSelectableVisitor resolveSel = new ResolveSelectableVisitor(db);
        this._condition = resolveSel.visit(this._condition, null, this.toArray(table));
    }

    public boolean evaluate(RowEvent event) throws AxionException {
        return this.evaluate(event, event.getTable().makeRowDecorator());
    }

    public boolean evaluate(RowEvent event, RowDecorator dec) throws AxionException {
        Row row = event.getNewRow();
        return null == row ? true : this.check(row, dec);
    }

    public boolean evaluate(RowIterator oldRows, RowIterator newRows, Table table) throws AxionException {
        if (null == newRows || newRows.isEmpty()) {
            return true;
        }
        RowDecorator dec = table.makeRowDecorator();
        while (newRows.hasNext()) {
            if (this.check(newRows.next(), dec)) continue;
            return false;
        }
        return true;
    }

    private boolean check(Row row, RowDecorator dec) throws AxionException {
        dec.setRow(row);
        Boolean result = (Boolean)this._condition.evaluate(dec);
        return result == null ? true : result;
    }
}

