/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import org.axiondb.AxionException;
import org.axiondb.BaseSelectable;
import org.axiondb.DataType;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.TableIdentifier;
import org.axiondb.types.AnyType;

public class ColumnIdentifier
extends BaseSelectable
implements Selectable {
    private ColumnIdentifier _canonicalForm;
    private TableIdentifier _table;
    private DataType _type;
    private static final long serialVersionUID = -5021851410960110853L;

    public ColumnIdentifier(String column) {
        this(null, column);
    }

    public ColumnIdentifier(TableIdentifier table, String columnName) {
        this(table, columnName, null);
    }

    public ColumnIdentifier(TableIdentifier table, String columnName, String columnAlias) {
        this(table, columnName, columnAlias, null);
    }

    public ColumnIdentifier(TableIdentifier table, String columnName, String columnAlias, DataType type) {
        this.setName(columnName);
        if (null == this._table) {
            this._table = table;
        }
        this.setAlias(columnAlias);
        this._type = null == type ? AnyType.INSTANCE : type;
    }

    public boolean equals(Object otherobject) {
        if (this == otherobject || this._canonicalForm != null && this._canonicalForm == otherobject) {
            return true;
        }
        if (otherobject instanceof ColumnIdentifier) {
            ColumnIdentifier that = (ColumnIdentifier)otherobject;
            String thisName = this.getName();
            String thatName = that.getName();
            String thisAlias = this.getAlias();
            String thatAlias = that.getAlias();
            return (null == thisName ? null == thatName : thisName.equals(thatName)) && (null == this._table ? null == that._table : this._table.equals(that._table)) && (null == thisAlias ? null == thatAlias : thisAlias.equals(thatAlias));
        }
        return false;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        if (null == row) {
            throw new AxionException("Expected non-null RowDecorator here.");
        }
        return row.get(this);
    }

    public ColumnIdentifier getCanonicalIdentifier() {
        ColumnIdentifier cid = this._canonicalForm;
        if (null == cid) {
            this._canonicalForm = cid = new ColumnIdentifier(this._table, this.getName(), null, this._type);
        }
        return cid;
    }

    public final DataType getDataType() {
        return this._type;
    }

    public final String getTableAlias() {
        return null == this._table ? null : this._table.getTableAlias();
    }

    public final TableIdentifier getTableIdentifier() {
        return this._table;
    }

    public final String getTableName() {
        return null == this._table ? null : this._table.getTableName();
    }

    public int hashCode() {
        int hashCode = this._hash;
        if (hashCode == 0) {
            String name = this.getName();
            String alias = this.getAlias();
            if (null != name) {
                hashCode = name.hashCode();
            }
            if (null != alias) {
                hashCode ^= alias.hashCode();
            }
            if (null != this._table) {
                hashCode ^= this._table.hashCode() << 4;
            }
            this._hash = hashCode;
        }
        return hashCode;
    }

    public void setDataType(DataType type) {
        this._type = null == type ? AnyType.INSTANCE : type;
        this.clearCanonicalForm();
    }

    public void setName(String column) {
        if (column != null) {
            int pivot = column.indexOf(".");
            if (pivot != -1) {
                this.setTableIdentifier(new TableIdentifier(column.substring(0, pivot)));
                column = column.substring(pivot + 1);
            }
            super.setName(column);
        }
        this.clearCanonicalForm();
    }

    public void setTableIdentifier(TableIdentifier table) {
        this._table = table;
        this._hash = 0;
        this.clearCanonicalForm();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.getTableIdentifier() != null) {
            result.append("(");
            result.append(this.getTableIdentifier().toString());
            result.append(").");
        }
        result.append(this.getName());
        if (null != this.getAlias()) {
            result.append(" AS ");
            result.append(this.getAlias());
        }
        return result.toString();
    }

    private final void clearCanonicalForm() {
        this._canonicalForm = null;
    }
}

