/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.EventBufferResultsProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTManager;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryCallGraphBuilder;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilerAppHandler;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilingPointsProcessor;
import org.netbeans.lib.profiler.tests.jfluid.utils.Utils;
import org.netbeans.lib.profiler.utils.StringUtils;

public abstract class MemorySnapshotTestCase
extends CommonProfilerTestCase {
    MemoryCallGraphBuilder builder = new MemoryCallGraphBuilder();
    MemoryResultListener resultListener = null;

    public MemorySnapshotTestCase(String name) {
        super(name);
    }

    protected void checkClasses(MemoryResultsSnapshot snapshot, String[] prefixes) {
        ArrayList<String> list = new ArrayList<String>(128);
        if (snapshot instanceof AllocMemoryResultsSnapshot) {
            AllocMemoryResultsSnapshot alsnapshot = (AllocMemoryResultsSnapshot)snapshot;
            int[] objcnts = alsnapshot.getObjectsCounts();
            long[] objsizes = alsnapshot.getObjectsSizePerClass();
            String[] classnames = alsnapshot.getClassNames();
            for (int i = 0; i < snapshot.getNProfiledClasses(); ++i) {
                boolean match = false;
                for (int j = 0; j < prefixes.length; ++j) {
                    if (!classnames[i].startsWith(prefixes[j])) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                StringBuffer out = new StringBuffer();
                out.append(this.complete(StringUtils.userFormClassName((String)classnames[i]), 32));
                out.append(this.complete(String.valueOf(objcnts[i]), 8));
                list.add(out.toString());
            }
            this.ref(this.complete("Name", 32) + this.complete("Objects", 8));
        } else if (snapshot instanceof LivenessMemoryResultsSnapshot) {
            LivenessMemoryResultsSnapshot lsnapshot = (LivenessMemoryResultsSnapshot)snapshot;
            this.log("Max Value:        " + lsnapshot.getMaxValue());
            this.log("Number Alloc:     " + lsnapshot.getNAlloc());
            this.log("Instr Classes:    " + lsnapshot.getNInstrClasses());
            this.log("Total tracked:    " + lsnapshot.getNTotalTracked());
            this.log("Tracked bytes:    " + lsnapshot.getNTotalTrackedBytes());
            this.log("Tracked items:    " + lsnapshot.getNTrackedItems());
            float[] avgage = lsnapshot.getAvgObjectAge();
            int[] maxSurvGen = lsnapshot.getMaxSurvGen();
            long[] ntrackedallocobjects = lsnapshot.getNTrackedAllocObjects();
            int[] ntrackedliveobjects = lsnapshot.getNTrackedLiveObjects();
            int[] totalAllocObjects = lsnapshot.getnTotalAllocObjects();
            String[] classnames = lsnapshot.getClassNames();
            long[] trackedLiveObjectsSize = lsnapshot.getTrackedLiveObjectsSize();
            for (int i = 0; i < snapshot.getNProfiledClasses(); ++i) {
                boolean match = false;
                for (int j = 0; j < prefixes.length; ++j) {
                    if (!classnames[i].startsWith(prefixes[j])) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                StringBuffer out = new StringBuffer();
                out.append(this.complete(StringUtils.userFormClassName((String)classnames[i]), 32));
                out.append(this.complete(String.valueOf(ntrackedliveobjects[i]), 10));
                out.append(this.complete(String.valueOf(ntrackedallocobjects[i]), 8));
                out.append(this.complete(String.valueOf(totalAllocObjects[i]), 8));
                list.add(out.toString());
            }
            this.ref(this.complete("Name", 32) + this.complete("LiveObjs", 10) + this.complete("Allocs", 8) + this.complete("Total", 8));
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            this.ref(list.get(i));
        }
        this.ref("");
    }

    protected void checkMemoryResults(TargetAppRunner targetAppRunner, String[] classPrefixes, String stacktraceClass) throws Exception {
        targetAppRunner.getProfilerClient().forceObtainedResultsDump();
        boolean gotResults = this.resultListener.wait4results(10000L);
        MemorySnapshotTestCase.assertTrue((String)"No memory results available after 10s", (boolean)gotResults);
        this.log("results obtained: " + System.currentTimeMillis());
        MemoryResultsSnapshot snapshot = targetAppRunner.getProfilerClient().getMemoryProfilingResultsSnapshot(false);
        MemorySnapshotTestCase.assertTrue((snapshot != null ? 1 : 0) != 0);
        this.log("snapshot taken: " + snapshot);
        this.ref(snapshot.containsStacks() ? "Contains stacks." : "Does not contain stacks.");
        this.log("Begin time:       " + new Date(snapshot.getBeginTime()));
        this.log("Profiled classes: " + snapshot.getNProfiledClasses());
        this.log("Time Taken:       " + new Date(snapshot.getTimeTaken()));
        this.checkClasses(snapshot, classPrefixes);
        if (snapshot.containsStacks()) {
            int classid = -1;
            String[] classes = snapshot.getClassNames();
            for (int i = 0; i < snapshot.getNProfiledClasses(); ++i) {
                if (!classes[i].replace('/', '.').equals(stacktraceClass)) continue;
                classid = i;
            }
            MemorySnapshotTestCase.assertTrue((String)("Stack trace class wasn't find " + stacktraceClass), (classid > -1 ? 1 : 0) != 0);
            MemoryCCTManager manager = new MemoryCCTManager(snapshot, classid, false);
            if (!manager.isEmpty()) {
                PresoObjAllocCCTNode root = manager.getRootNode();
                this.refNodes(root, "");
            }
        }
        this.testSerialization(snapshot);
    }

    protected boolean equals(String[] a1, String[] a2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a1[i].equals(a2[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(int[] a1, int[] a2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(long[] a1, long[] a2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(float[] a1, float[] a2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(RuntimeMemoryCCTNode a1, RuntimeMemoryCCTNode a2) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        a1.writeToStream(dos);
        dos.close();
        byte[] bytes = baos.toByteArray();
        baos = new ByteArrayOutputStream();
        dos = new DataOutputStream(baos);
        a2.writeToStream(dos);
        dos.close();
        byte[] bytes2 = baos.toByteArray();
        if (bytes.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    protected ProfilerEngineSettings initMemorySnapshotTest(String projectName, String className) {
        ProfilerEngineSettings settings = this.initTest(projectName, className, null);
        settings.setThreadCPUTimerOn(false);
        settings.setAllocTrackEvery(1);
        settings.setRunGCOnGetResultsInMemoryProfiling(true);
        return settings;
    }

    protected void refNodes(PresoObjAllocCCTNode root, String tab) {
        this.ref(tab + root);
        if (root.getNChildren() > 0) {
            root.sortChildren(1, false);
            CCTNode[] nodes = root.getChildren();
            for (int i = 0; i < nodes.length; ++i) {
                this.refNodes((PresoObjAllocCCTNode)nodes[i], tab + " ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMemorySnapshotTest(ProfilerEngineSettings settings, int instrMode, String[] classPrefixes, String stacktraceClass) {
        MemorySnapshotTestCase.assertTrue((this.builder != null ? 1 : 0) != 0);
        TestProfilerAppHandler handler = new TestProfilerAppHandler(this);
        TargetAppRunner runner = new TargetAppRunner(settings, (AppStatusHandler)handler, (ProfilingPointsProcessor)new TestProfilingPointsProcessor());
        runner.addProfilingEventListener(Utils.createProfilingListener(this));
        this.builder.removeAllListeners();
        ProfilingResultsDispatcher.getDefault().removeAllListeners();
        this.resultListener = new MemoryResultListener();
        this.builder.addListener((CCTProvider.Listener)this.resultListener);
        ProfilingResultsDispatcher.getDefault().addListener((MemoryProfilingResultsListener)this.builder);
        this.builder.startup(runner.getProfilerClient());
        EventBufferResultsProvider.getDefault().startup(runner.getProfilerClient());
        try {
            MemorySnapshotTestCase.assertTrue((String)"not read calibration data", (boolean)runner.readSavedCalibrationData());
            Process p = this.startTargetVM(runner);
            MemorySnapshotTestCase.assertNotNull((String)"Target JVM is not started", (Object)p);
            this.bindStreams(p);
            runner.connectToStartedVMAndStartTA();
            runner.getProfilerClient().initiateMemoryProfInstrumentation(instrMode);
            this.waitForStatus(1);
            MemorySnapshotTestCase.assertTrue((String)"runner is not running", (boolean)runner.targetAppIsRunning());
            this.waitForStatus(6);
            if (!this.isStatus(4)) {
                this.waitForStatus(4);
            }
            this.checkMemoryResults(runner, classPrefixes, stacktraceClass);
            this.setStatus(8);
        }
        catch (Exception ex) {
            this.log(ex);
            MemorySnapshotTestCase.assertTrue((String)("Exception thrown: " + ex.getMessage()), (boolean)false);
        }
        finally {
            ProfilingResultsDispatcher.getDefault().pause(true);
            this.builder.shutdown();
            this.builder.removeListener((CCTProvider.Listener)this.resultListener);
            ProfilingResultsDispatcher.getDefault().removeListener((MemoryProfilingResultsListener)this.builder);
            this.finalizeTest(runner);
        }
    }

    protected void testSerialization(MemoryResultsSnapshot snapshot) {
        try {
            LivenessMemoryResultsSnapshot s2;
            LivenessMemoryResultsSnapshot s1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            snapshot.writeToStream(dos);
            dos.close();
            byte[] bytes = baos.toByteArray();
            Object snapshot2 = snapshot instanceof LivenessMemoryResultsSnapshot ? new LivenessMemoryResultsSnapshot() : new AllocMemoryResultsSnapshot();
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bis);
            snapshot2.readFromStream(dis);
            dis.close();
            if (snapshot instanceof LivenessMemoryResultsSnapshot) {
                s1 = (LivenessMemoryResultsSnapshot)snapshot;
                s2 = snapshot2;
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff containsStacks", (boolean)s1.containsStacks(), (boolean)s2.containsStacks());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff beginTime", (long)s1.getBeginTime(), (long)s2.getBeginTime());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff MaxValue", (long)s1.getMaxValue(), (long)s2.getMaxValue());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff NAlloc", (int)s1.getNAlloc(), (int)s2.getNAlloc());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff NInstrClasses", (int)s1.getNInstrClasses(), (int)s2.getNInstrClasses());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff NProfiledClasses", (int)s1.getNProfiledClasses(), (int)s2.getNProfiledClasses());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff NTotalTracked", (long)s1.getNTotalTracked(), (long)s2.getNTotalTracked());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff NTotalTrackedBytes", (long)s1.getNTotalTrackedBytes(), (long)s2.getNTotalTrackedBytes());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff NTrackedItems", (int)s1.getNTrackedItems(), (int)s2.getNTrackedItems());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff TimeTaken", (long)s1.getTimeTaken(), (long)s2.getTimeTaken());
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff AvgObjectAge", (boolean)this.equals(s1.getAvgObjectAge(), s2.getAvgObjectAge(), s1.getNProfiledClasses()));
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff ClassNames", (boolean)this.equals(s1.getClassNames(), s2.getClassNames(), s1.getNProfiledClasses()));
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff MaxSurvGen", (boolean)this.equals(s1.getMaxSurvGen(), s2.getMaxSurvGen(), s1.getNProfiledClasses()));
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff NTrackedAllocObjects", (boolean)this.equals(s1.getNTrackedAllocObjects(), s2.getNTrackedAllocObjects(), s1.getNProfiledClasses()));
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff NTrackedLiveObjects", (boolean)this.equals(s1.getNTrackedLiveObjects(), s2.getNTrackedLiveObjects(), s1.getNProfiledClasses()));
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff ObjectsSizePerClass", (boolean)this.equals(s1.getObjectsSizePerClass(), s2.getObjectsSizePerClass(), s1.getNProfiledClasses()));
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff TrackedLiveObjectsSize", (boolean)this.equals(s1.getTrackedLiveObjectsSize(), s2.getTrackedLiveObjectsSize(), s1.getNProfiledClasses()));
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff nTotalAllocObjects", (boolean)this.equals(s1.getnTotalAllocObjects(), s2.getnTotalAllocObjects(), s1.getNProfiledClasses()));
            } else {
                s1 = (AllocMemoryResultsSnapshot)snapshot;
                s2 = (AllocMemoryResultsSnapshot)snapshot2;
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff containsStacks", (boolean)s1.containsStacks(), (boolean)s2.containsStacks());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff beginTime", (long)s1.getBeginTime(), (long)s2.getBeginTime());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff NProfiledClasses", (int)s1.getNProfiledClasses(), (int)s2.getNProfiledClasses());
                MemorySnapshotTestCase.assertEquals((String)"Snapshot Serialization: diff TimeTaken", (long)s1.getTimeTaken(), (long)s2.getTimeTaken());
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff ClassNames", (boolean)this.equals(s1.getClassNames(), s2.getClassNames(), s1.getNProfiledClasses()));
                MemorySnapshotTestCase.assertTrue((String)"Snapshot Serialization: diff ObjectsSizePerClass", (boolean)this.equals(s1.getObjectsSizePerClass(), s2.getObjectsSizePerClass(), s1.getNProfiledClasses()));
            }
            if (snapshot.containsStacks()) {
                Field field = snapshot.getClass().getSuperclass().getDeclaredField("stacksForClasses");
                field.setAccessible(true);
                RuntimeMemoryCCTNode[] stacksForClasses = (RuntimeMemoryCCTNode[])field.get(snapshot);
                RuntimeMemoryCCTNode[] stacksForClasses2 = (RuntimeMemoryCCTNode[])field.get(snapshot2);
                for (int i = 0; i < stacksForClasses.length; ++i) {
                    if (stacksForClasses[i] == null) continue;
                    MemorySnapshotTestCase.assertTrue((String)("Snapshot Serialization: diff stacktraces " + snapshot.getClassName(i)), (boolean)this.equals(stacksForClasses[i], stacksForClasses2[i]));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MemorySnapshotTestCase.assertTrue((String)("Snapshot Serialization: " + ex.getClass().getName() + ": " + ex.getMessage()), (boolean)false);
        }
    }

    private static class MemoryResultListener
    implements MemoryCCTProvider.Listener {
        private final Object resultsLock = new Object();
        private boolean hasResults = false;

        private MemoryResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctEstablished(RuntimeCCTNode appRootNode) {
            System.out.println("Memory CCT Established");
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = true;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctReset() {
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = false;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wait4results(long timeout) {
            Object object = this.resultsLock;
            synchronized (object) {
                if (!this.hasResults) {
                    try {
                        this.resultsLock.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                return this.hasResults;
            }
        }
    }
}

