/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.memory;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.tests.jfluid.memory.MemorySnapshotTestCase;

public class MemorySnapshotTest
extends MemorySnapshotTestCase {
    public MemorySnapshotTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MemorySnapshotTest.class);
        return suite;
    }

    public void testSettingsAllocations() {
        ProfilerEngineSettings settings = this.initMemorySnapshotTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(0);
        this.startMemorySnapshotTest(settings, 4, new String[]{"simple"}, "simple.memory.Bean");
    }

    public void testSettingsAllocationsServer() {
        ProfilerEngineSettings settings = this.initMemorySnapshotTest("j2se-simple", "simple.memory.Memory1");
        this.addJVMArgs(settings, "-server");
        settings.setAllocStackTraceLimit(0);
        this.startMemorySnapshotTest(settings, 4, new String[]{"simple"}, "simple.memory.Bean");
    }

    public void testSettingsAllocationsStackTraces() {
        ProfilerEngineSettings settings = this.initMemorySnapshotTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(-1);
        this.startMemorySnapshotTest(settings, 4, new String[]{"simple"}, "simple.memory.Bean");
    }

    public void testSettingsAllocationsStackTracesServer() {
        ProfilerEngineSettings settings = this.initMemorySnapshotTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(-1);
        this.addJVMArgs(settings, "-server");
        this.startMemorySnapshotTest(settings, 4, new String[]{"simple"}, "simple.memory.Bean");
    }

    public void testSettingsLiveness() {
        ProfilerEngineSettings settings = this.initMemorySnapshotTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(0);
        this.startMemorySnapshotTest(settings, 5, new String[]{"simple"}, "simple.memory.Bean");
    }

    public void testSettingsLivenessServer() {
        ProfilerEngineSettings settings = this.initMemorySnapshotTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(0);
        this.addJVMArgs(settings, "-server");
        this.startMemorySnapshotTest(settings, 5, new String[]{"simple"}, "simple.memory.Bean");
    }

    public void testSettingsLivenessStackTraces() {
        ProfilerEngineSettings settings = this.initMemorySnapshotTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(-1);
        this.startMemorySnapshotTest(settings, 5, new String[]{"simple"}, "simple.memory.Bean");
    }

    public void testSettingsLivenessStackTracesServer() {
        ProfilerEngineSettings settings = this.initMemorySnapshotTest("j2se-simple", "simple.memory.Memory1");
        settings.setAllocStackTraceLimit(-1);
        this.addJVMArgs(settings, "-server");
        this.startMemorySnapshotTest(settings, 5, new String[]{"simple"}, "simple.memory.Bean");
    }
}

