/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.cpu;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.EventBufferResultsProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileBuilder;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilerAppHandler;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilingPointsProcessor;
import org.netbeans.lib.profiler.tests.jfluid.utils.Utils;
import org.netbeans.lib.profiler.utils.StringUtils;

public abstract class CPUSnapshotTestCase
extends CommonProfilerTestCase {
    public CPUSnapshotTestCase(String name) {
        super(name);
    }

    protected boolean checkSerialization(CPUResultsSnapshot snapshot) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            snapshot.writeToStream(dos);
            dos.close();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            CPUResultsSnapshot snapshot2 = new CPUResultsSnapshot();
            snapshot2.readFromStream(dis);
            dis.close();
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            snapshot2.writeToStream(dos);
            dos.close();
            byte[] bytes2 = baos.toByteArray();
            if (bytes.length != bytes2.length) {
                return false;
            }
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == bytes2[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected void checkSumsOfCCTNodes(PrestimeCPUCCTNode node, String pre, double tolerance, String[] filterout, int level) {
        this.log(this.complete(pre + node.getNodeName(), 62) + this.complete(StringUtils.mcsTimeToString((long)node.getTotalTime0()), 9) + " ms   (" + this.complete(StringUtils.floatPerCentToString((float)node.getTotalTime0InPerCent()), 7) + " %)  " + this.complete(String.valueOf(node.getNCalls()), 3));
        boolean exclude = false;
        if (filterout != null) {
            for (int i = 0; i < filterout.length; ++i) {
                if (!node.getNodeName().startsWith(filterout[i])) continue;
                exclude = true;
                break;
            }
        }
        if (!exclude) {
            long time = 0L;
            float percent = 0.0f;
            for (int i = 0; i < node.getNChildren(); ++i) {
                PrestimeCPUCCTNode pnode = (PrestimeCPUCCTNode)node.getChild(i);
                this.checkSumsOfCCTNodes(pnode, pre + " ", tolerance, filterout, level + 1);
                time += pnode.getTotalTime0();
                percent += pnode.getTotalTime0InPerCent();
            }
            if (level > 1 && node.getNChildren() > 0) {
                double timediff = (double)Math.abs(time - node.getTotalTime0()) * 100.0 / (double)node.getTotalTime0();
                double percentdiff = (double)Math.abs(percent - node.getTotalTime0InPerCent()) * 100.0 / (double)node.getTotalTime0InPerCent();
                if (timediff > tolerance || percentdiff > tolerance) {
                    this.log("Time diff: " + timediff + " %");
                    this.log("Percent diff: " + percentdiff + " %");
                    CPUSnapshotTestCase.assertTrue((String)"Node's and sum of subnodes values differ", (boolean)false);
                }
            }
        }
    }

    protected int[] findThreadAndMethod(PrestimeCPUCCTNode node, String[] method, String[] filterout) {
        boolean exclude = false;
        if (filterout != null) {
            for (int i = 0; i < filterout.length; ++i) {
                if (!node.getNodeName().startsWith(filterout[i])) continue;
                exclude = true;
                break;
            }
        }
        if (!exclude) {
            int i;
            String[] nmethod = node.getMethodClassNameAndSig();
            boolean found = true;
            for (i = 0; i < nmethod.length; ++i) {
                if (nmethod[i].equals(method[i])) continue;
                found = false;
            }
            if (found) {
                return new int[]{node.getThreadId(), node.getMethodId()};
            }
            for (i = 0; i < node.getNChildren(); ++i) {
                PrestimeCPUCCTNode pnode = (PrestimeCPUCCTNode)node.getChild(i);
                int[] ret = this.findThreadAndMethod(pnode, method, filterout);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    protected ProfilerEngineSettings initSnapshotTest(String projectName, String mainClass, String[][] rootMethods) {
        ProfilerEngineSettings settings = this.initTest(projectName, mainClass, rootMethods);
        settings.setCPUProfilingType(0);
        settings.setInstrScheme(3);
        settings.setInstrumentEmptyMethods(false);
        settings.setInstrumentGetterSetterMethods(false);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentSpawnedThreads(true);
        settings.setExcludeWaitTime(true);
        settings.setThreadCPUTimerOn(false);
        settings.setCPUProfilingType(0);
        return settings;
    }

    protected void refOfCCTNodes(PrestimeCPUCCTNode node, String pre, boolean time, boolean percent, boolean invocations) {
        this.ref(this.complete(pre + node.getNodeName(), 62) + (!time ? "" : this.complete(String.valueOf((double)node.getTotalTime0() / 1000.0), 9) + " ms   ") + (!percent ? "" : this.complete(String.valueOf(node.getTotalTime0InPerCent()), 7) + " %  ") + (!invocations ? "" : this.complete(String.valueOf(node.getNCalls()), 3)));
        for (int i = 0; i < node.getNChildren(); ++i) {
            PrestimeCPUCCTNode pnode = (PrestimeCPUCCTNode)node.getChild(i);
            this.refOfCCTNodes(pnode, pre + " ", time, percent, invocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSnapshotTest(ProfilerEngineSettings settings, String[] reverseMethod, long initDelay, double diffPercent, String[] filterout) {
        CPUCallGraphBuilder builder = new CPUCallGraphBuilder();
        CPUSnapshotTestCase.assertTrue((builder != null ? 1 : 0) != 0);
        TargetAppRunner runner = new TargetAppRunner(settings, (AppStatusHandler)new TestProfilerAppHandler(this), (ProfilingPointsProcessor)new TestProfilingPointsProcessor());
        runner.addProfilingEventListener(Utils.createProfilingListener(this));
        builder.removeAllListeners();
        ProfilingResultsDispatcher.getDefault().removeAllListeners();
        CPUResultListener resultListener = new CPUResultListener();
        builder.addListener((CCTProvider.Listener)resultListener);
        FlatProfileBuilder flattener = new FlatProfileBuilder();
        builder.addListener((CCTProvider.Listener)flattener);
        flattener.setContext(runner.getProfilerClient());
        ProfilingResultsDispatcher.getDefault().addListener((CPUProfilingResultListener)builder);
        builder.startup(runner.getProfilerClient());
        EventBufferResultsProvider.getDefault().startup(runner.getProfilerClient());
        try {
            runner.readSavedCalibrationData();
            Process p = this.startTargetVM(runner);
            CPUSnapshotTestCase.assertNotNull((String)"Target JVM is not started", (Object)p);
            this.bindStreams(p);
            runner.connectToStartedVMAndStartTA();
            runner.getProfilerClient().initiateRecursiveCPUProfInstrumentation(settings.getInstrumentationRootMethods());
            this.waitForStatus(1);
            CPUSnapshotTestCase.assertTrue((String)"runner is not running", (boolean)runner.targetAppIsRunning());
            if (initDelay == 0L) {
                this.waitForStatus(4);
            } else {
                Thread.sleep(initDelay);
            }
            if (runner.targetJVMIsAlive()) {
                int[] sigs;
                this.log("obtaining results " + String.valueOf(System.currentTimeMillis()));
                CPUSnapshotTestCase.assertTrue((String)"Results do not exist - issue 65185.", (boolean)runner.getProfilerClient().cpuResultsExist());
                CPUResultsSnapshot snapshot = runner.getProfilerClient().getCPUProfilingResultsSnapshot();
                this.log("\nSnapshot:");
                PrestimeCPUCCTNode root = snapshot.getRootNode(0);
                this.log("Snapshot taken: " + snapshot.getTimeTaken());
                this.log("Checking tree ...");
                this.checkSumsOfCCTNodes(root, "", diffPercent, filterout, 0);
                this.log("Checking serialization");
                CPUSnapshotTestCase.assertTrue((String)"The snapshot is not serialized/deserialized right.", (boolean)this.checkSerialization(snapshot));
                this.log("Checking reverse call");
                if (reverseMethod != null && (sigs = this.findThreadAndMethod(root, reverseMethod, filterout)) != null) {
                    PrestimeCPUCCTNode revers = snapshot.getReverseCCT(-1, sigs[1], 0);
                    if (initDelay > 0L) {
                        this.refOfCCTNodes(revers, "", false, false, false);
                    } else {
                        this.refOfCCTNodes(revers, "", false, false, true);
                    }
                }
                this.log("");
            }
            this.setStatus(8);
        }
        catch (Exception ex) {
            this.log(ex);
            CPUSnapshotTestCase.assertTrue((String)("Exception thrown: " + ex.getMessage()), (boolean)false);
        }
        finally {
            ProfilingResultsDispatcher.getDefault().pause(true);
            builder.shutdown();
            flattener.setContext(null);
            builder.removeListener((CCTProvider.Listener)flattener);
            builder.removeListener((CCTProvider.Listener)resultListener);
            ProfilingResultsDispatcher.getDefault().removeListener((CPUProfilingResultListener)builder);
            this.finalizeTest(runner);
        }
    }

    private class CPUResultListener
    implements CPUCCTProvider.Listener {
        private final Object resultsLock = new Object();
        private boolean hasResults = false;

        private CPUResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctEstablished(RuntimeCCTNode appRootNode) {
            CPUSnapshotTestCase.this.log("CCT Results established");
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = true;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctReset() {
            CPUSnapshotTestCase.this.log("CCT Results reset");
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = false;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wait4results(long timeout) {
            Object object = this.resultsLock;
            synchronized (object) {
                if (!this.hasResults) {
                    try {
                        this.resultsLock.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                return this.hasResults;
            }
        }
    }
}

