/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

class JGoPositionArray {
    static final int OCCUPIED = 0;
    static final int START = 1;
    static final int MAXDIST = Integer.MAX_VALUE;
    private boolean myInvalid = true;
    private int myMinX = 1;
    private int myMinY = 1;
    private int myMaxX = -1;
    private int myMaxY = -1;
    private Rectangle myBounds = new Rectangle(1, 1, -2, -2);
    private int myCellX = 10;
    private int myCellY = 10;
    private Dimension myCellSize = new Dimension(10, 10);
    private int[][] myArray = null;
    private int myUpperBoundX = 0;
    private int myUpperBoundY = 0;

    public final void initialize(Rectangle rect) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        int minx = rect.x;
        int miny = rect.y;
        int maxx = rect.x + rect.width;
        int maxy = rect.y + rect.height;
        this.myMinX = (int)Math.floor((double)(minx - this.myCellX) / (double)this.myCellX) * this.myCellX;
        this.myMinY = (int)Math.floor((double)(miny - this.myCellY) / (double)this.myCellY) * this.myCellY;
        this.myMaxX = (int)Math.ceil((double)(maxx + 2 * this.myCellX) / (double)this.myCellX) * this.myCellX;
        this.myMaxY = (int)Math.ceil((double)(maxy + 2 * this.myCellY) / (double)this.myCellY) * this.myCellY;
        this.myBounds.x = this.myMinX;
        this.myBounds.y = this.myMinY;
        this.myBounds.width = this.myMaxX - this.myMinX;
        this.myBounds.height = this.myMaxY - this.myMinY;
        int xrange = 1 + (int)Math.ceil((double)(this.myMaxX - this.myMinX) / (double)this.myCellX);
        int yrange = 1 + (int)Math.ceil((double)(this.myMaxY - this.myMinY) / (double)this.myCellY);
        if (this.myArray == null || this.myUpperBoundX < xrange - 1 || this.myUpperBoundY < yrange - 1) {
            this.myArray = new int[xrange][yrange];
            this.myUpperBoundX = xrange - 1;
            this.myUpperBoundY = yrange - 1;
        }
        this.setAll(Integer.MAX_VALUE);
    }

    public final boolean isInvalid() {
        return this.myInvalid;
    }

    public final void setInvalid(boolean v) {
        this.myInvalid = v;
    }

    public final Rectangle getBounds() {
        return this.myBounds;
    }

    public final Dimension getCellSize() {
        return this.myCellSize;
    }

    public final void setCellSize(Dimension value) {
        if (value.width >= 1 && value.height >= 1 && (value.width != this.myCellX || value.height != this.myCellY)) {
            this.myCellX = value.width;
            this.myCellY = value.height;
            this.myCellSize.width = this.myCellX;
            this.myCellSize.height = this.myCellY;
            this.initialize(new Rectangle(this.myMinX, this.myMinY, this.myMaxX - this.myMinX, this.myMaxY - this.myMinY));
        }
    }

    public final boolean inBounds(int x, int y) {
        return this.myMinX <= x && x <= this.myMaxX && this.myMinY <= y && y <= this.myMaxY;
    }

    public final int getDist(Point p) {
        return this.getDist(p.x, p.y);
    }

    public final int getDist(int x, int y) {
        if (!this.inBounds(x, y)) {
            return 0;
        }
        x -= this.myMinX;
        y -= this.myMinY;
        int ix = x /= this.myCellX;
        int iy = y /= this.myCellY;
        return this.myArray[ix][iy];
    }

    public final void setDist(Point p, int v) {
        this.setDist(p.x, p.y, v);
    }

    public final void setDist(int x, int y, int v) {
        if (!this.inBounds(x, y)) {
            return;
        }
        x -= this.myMinX;
        y -= this.myMinY;
        int ix = x /= this.myCellX;
        int iy = y /= this.myCellY;
        this.myArray[ix][iy] = v;
    }

    public final void setAll(int v) {
        if (this.myArray == null) {
            return;
        }
        for (int ix = 0; ix <= this.myUpperBoundX; ++ix) {
            for (int iy = 0; iy <= this.myUpperBoundY; ++iy) {
                this.myArray[ix][iy] = v;
            }
        }
    }

    public final void setAllUnoccupied(int v) {
        if (this.myArray == null) {
            return;
        }
        for (int ix = 0; ix <= this.myUpperBoundX; ++ix) {
            for (int iy = 0; iy <= this.myUpperBoundY; ++iy) {
                if (this.myArray[ix][iy] == 0) continue;
                this.myArray[ix][iy] = v;
            }
        }
    }

    public final boolean isOccupied(int x, int y) {
        return this.getDist(x, y) == 0;
    }

    public final boolean isUnoccupied(int x, int y, int w, int h) {
        int ix = (x - this.myMinX) / this.myCellX;
        int iy = (y - this.myMinY) / this.myCellY;
        int iw = Math.max(0, w) / this.myCellX + 1;
        int ih = Math.max(0, h) / this.myCellY + 1;
        int mx = Math.min(ix + iw, this.myUpperBoundX);
        int my = Math.min(iy + ih, this.myUpperBoundY);
        for (int i = ix; i <= mx; ++i) {
            for (int j = iy; j <= my; ++j) {
                if (this.myArray[i][j] != 0) continue;
                return false;
            }
        }
        return true;
    }

    private final int Ray(int x, int y, int inc, boolean vert, int lowx, int hix, int lowy, int hiy) {
        int val = this.myArray[x][y];
        if (val != 0 && val != Integer.MAX_VALUE) {
            if (vert) {
                y += inc;
            } else {
                x += inc;
            }
            while (lowx <= x && x <= hix && lowy <= y && y <= hiy && ++val < this.myArray[x][y]) {
                this.myArray[x][y] = val;
                if (vert) {
                    y += inc;
                    continue;
                }
                x += inc;
            }
        }
        if (vert) {
            return y;
        }
        return x;
    }

    private final void Spread(int x, int y, int inc, boolean vert, int lowx, int hix, int lowy, int hiy) {
        if (x < lowx || x > hix || y < lowy || y > hiy) {
            return;
        }
        int end = this.Ray(x, y, inc, vert, lowx, hix, lowy, hiy);
        if (vert) {
            if (inc > 0) {
                for (int yy = y + inc; yy < end; yy += inc) {
                    this.Spread(x, yy, 1, !vert, lowx, hix, lowy, hiy);
                    this.Spread(x, yy, -1, !vert, lowx, hix, lowy, hiy);
                }
            } else {
                for (int yy = y + inc; yy > end; yy += inc) {
                    this.Spread(x, yy, 1, !vert, lowx, hix, lowy, hiy);
                    this.Spread(x, yy, -1, !vert, lowx, hix, lowy, hiy);
                }
            }
        } else if (inc > 0) {
            for (int xx = x + inc; xx < end; xx += inc) {
                this.Spread(xx, y, 1, !vert, lowx, hix, lowy, hiy);
                this.Spread(xx, y, -1, !vert, lowx, hix, lowy, hiy);
            }
        } else {
            for (int xx = x + inc; xx > end; xx += inc) {
                this.Spread(xx, y, 1, !vert, lowx, hix, lowy, hiy);
                this.Spread(xx, y, -1, !vert, lowx, hix, lowy, hiy);
            }
        }
    }

    private final int BreakOut(int x, int y, int inc, boolean vert, int lowx, int hix, int lowy, int hiy) {
        int val = 1;
        int oldval = this.myArray[x][y];
        this.myArray[x][y] = val;
        while (oldval == 0 && x > lowx && x < hix && y > lowy && y < hiy) {
            if (vert) {
                y += inc;
            } else {
                x += inc;
            }
            oldval = this.myArray[x][y];
            this.myArray[x][y] = val++;
        }
        if (vert) {
            return y;
        }
        return x;
    }

    private final void BreakIn(int x, int y, int inc, boolean vert, int lowx, int hix, int lowy, int hiy) {
        int oldval = this.myArray[x][y];
        this.myArray[x][y] = Integer.MAX_VALUE;
        while (oldval == 0 && x > lowx && x < hix && y > lowy && y < hiy) {
            if (vert) {
                y += inc;
            } else {
                x += inc;
            }
            oldval = this.myArray[x][y];
            this.myArray[x][y] = Integer.MAX_VALUE;
        }
    }

    public void propagate(int x1, int y1, double fromDir, int x2, int y2, double toDir, int bx1, int by1, int bx2, int by2) {
        boolean vert;
        double RIGHT = 0.0;
        double DOWN = 1.5707963267948966;
        double LEFT = Math.PI;
        double UP = 4.71238898038469;
        if (this.myArray == null) {
            return;
        }
        if (!this.inBounds(x1, y1)) {
            return;
        }
        x1 -= this.myMinX;
        x1 /= this.myCellX;
        y1 -= this.myMinY;
        y1 /= this.myCellY;
        if (!this.inBounds(x2, y2)) {
            return;
        }
        x2 -= this.myMinX;
        y2 -= this.myMinY;
        if (Math.abs(x1 - (x2 /= this.myCellX)) <= 1 && Math.abs(y1 - (y2 /= this.myCellY)) <= 1) {
            this.myArray[x1][y1] = 0;
            return;
        }
        bx1 -= this.myMinX;
        by1 -= this.myMinY;
        bx2 -= this.myMinX;
        by2 -= this.myMinY;
        int lowx = Math.max(0, Math.min(this.myUpperBoundX, bx1 /= this.myCellX));
        int hix = Math.min(this.myUpperBoundX, Math.max(0, bx2 /= this.myCellX));
        int lowy = Math.max(0, Math.min(this.myUpperBoundY, by1 /= this.myCellY));
        int hiy = Math.min(this.myUpperBoundY, Math.max(0, by2 /= this.myCellY));
        int ix = x1;
        int iy = y1;
        int inc = fromDir == 0.0 || fromDir == 1.5707963267948966 ? 1 : -1;
        boolean bl = vert = fromDir == 1.5707963267948966 || fromDir == 4.71238898038469;
        if (vert) {
            iy = this.BreakOut(ix, iy, inc, vert, lowx, hix, lowy, hiy);
        } else {
            ix = this.BreakOut(ix, iy, inc, vert, lowx, hix, lowy, hiy);
        }
        this.BreakIn(x2, y2, toDir == 0.0 || toDir == 1.5707963267948966 ? 1 : -1, toDir == 1.5707963267948966 || toDir == 4.71238898038469, lowx, hix, lowy, hiy);
        this.Spread(ix, iy, 1, false, lowx, hix, lowy, hiy);
        this.Spread(ix, iy, -1, false, lowx, hix, lowy, hiy);
        this.Spread(ix, iy, 1, true, lowx, hix, lowy, hiy);
        this.Spread(ix, iy, -1, true, lowx, hix, lowy, hiy);
    }
}

