/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.utils;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;

public class Logger {
    public static final int DEBUG = 10000;
    public static final int ERROR = 40000;
    public static final int FATAL = 50000;
    public static final int INFO = 20000;
    public static final int WARN = 30000;
    private static String configFile = "";
    private static final String DEFAULT_CONFIG_FILE = "com/sun/sql/framework/utils/logger.xml";
    private static boolean isInitialized = false;

    public static synchronized int debugLevel() {
        return 10000;
    }

    public static synchronized int errorLevel() {
        return 40000;
    }

    public static synchronized int infoLevel() {
        return 20000;
    }

    public static synchronized boolean isDebugEnabled(String category) {
        return java.util.logging.Logger.getLogger(category).isLoggable(Level.FINE);
    }

    public static synchronized void print(int level, String category, Object context, String msg) {
        Logger.printThrowable(level, category, context, msg, null);
    }

    public static synchronized void print(int level, String category, Object context, Throwable cause) {
        Logger.printThrowable(level, category, context, cause.toString(), cause);
    }

    public static synchronized void print(int level, String category, String msg) {
        Logger.printThrowable(level, category, null, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void printThrowable(int level, String category, Object aContext, String msg, Throwable e) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (!isInitialized) {
                Logger.getInstance();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            String outputMsg = msg;
            try {
                if (e != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    outputMsg = outputMsg + " - " + sw;
                    if (outputMsg.length() > 1900) {
                        outputMsg = outputMsg.substring(0, 1900);
                        outputMsg = outputMsg + aContext;
                        outputMsg = outputMsg + "\n MESSAGE WAS TRUNCATED \n";
                    }
                }
                msg = outputMsg;
                java.util.logging.Logger logInstance = java.util.logging.Logger.getLogger(category);
                switch (level) {
                    case 50000: {
                        logInstance.log(Level.SEVERE, msg);
                        break;
                    }
                    case 40000: {
                        logInstance.log(Level.SEVERE, msg);
                        break;
                    }
                    case 20000: {
                        logInstance.log(Level.INFO, msg);
                        break;
                    }
                    case 30000: {
                        logInstance.log(Level.WARNING, msg);
                        break;
                    }
                    default: {
                        logInstance.log(Level.FINE, msg);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    public static void setConfigFile(String fileName) {
        if (fileName != null) {
            configFile = fileName;
        }
        Logger.getInstance();
    }

    private static boolean configureJdk14Logging() {
        return true;
    }

    private static void getInstance() {
        if (configFile.equals("")) {
            configFile = DEFAULT_CONFIG_FILE;
        }
        if (!Logger.log4jIsConfigured()) {
            Logger.configureJdk14Logging();
        }
        isInitialized = true;
    }

    private static boolean log4jIsConfigured() {
        boolean configured = false;
        try {
            URL url = Logger.class.getClassLoader().getResource(configFile);
            Class<?> cfgClass = Class.forName("org.apache.log4j.xml.DOMConfigurator", true, Logger.class.getClassLoader());
            if (cfgClass != null) {
                if ("debug".equalsIgnoreCase(System.getProperty("run.mode"))) {
                    System.out.println("[SQLFramework] Log4J is installed; attempting to read configuration file.");
                }
                Method configureAndWatch = cfgClass.getMethod("configureAndWatch", String.class);
                if (url == null) {
                    System.out.println("ERROR: Can't find config file in Classpath: " + configFile + "; using file search");
                    File f = new File(configFile);
                    System.out.println("Config file " + configFile);
                    System.out.println("Config path " + f.getName());
                    Object[] configName = new Object[]{f.getName()};
                    Method configureStr = cfgClass.getMethod("configure", String.class);
                    if (configureStr != null) {
                        configureStr.invoke(null, configName);
                    }
                    if (configureAndWatch != null) {
                        configureAndWatch.invoke(null, configName);
                    }
                } else {
                    Method configureUrl = cfgClass.getMethod("configure", URL.class);
                    if (configureUrl != null) {
                        configureUrl.invoke(null, url);
                    }
                    if (configureAndWatch != null) {
                        configureAndWatch.invoke(null, url.getFile());
                    }
                }
            }
            configured = true;
        }
        catch (Throwable t) {
            String msg;
            if (t instanceof ClassNotFoundException && (msg = t.getLocalizedMessage()).indexOf("org.apache.log4j.xml.DOMConfigurator") != -1) {
                return false;
            }
            System.out.println("Error while attempting to configure Log4J logger:");
            Throwable cause = t.getCause();
            if (cause != null) {
                cause.printStackTrace(System.out);
            }
            t.printStackTrace(System.out);
        }
        return configured;
    }

    public Logger() {
        isInitialized = true;
    }
}

