/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLTask;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.ETLEngineImpl;
import com.sun.etl.engine.impl.ETLTaskThreadManager;
import com.sun.etl.engine.impl.WaitTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimerTask;

public class ETLTaskThread
extends TimerTask {
    private static final int END_TASK = 12;
    private static MessageManager messageManager = ETLEngineImpl.getPackageMessageManager();
    private static final int START_TASK = 11;
    private static final int USER_TASK = 20;
    private static final int WAIT_TASK = 13;
    private final String LOG_CATEGORY = ETLTaskThread.class.getName();
    private ETLTask task;
    private String taskId;
    private ETLTaskThreadManager taskManager;
    private ETLTaskNode taskNode;
    private int taskType;

    public ETLTaskThread(ETLTaskThreadManager theTaskManager, ETLTaskNode theETLTaskNode) throws ETLException {
        this.init(theTaskManager, theETLTaskNode);
        new Thread((Runnable)this, this.taskId).start();
    }

    public String getName() {
        return this.taskId;
    }

    public ETLTask getTask() {
        return this.task;
    }

    public int getTaskType(String categoryName) {
        int aTaskType = categoryName.equals("START") ? 11 : (categoryName.equals("STOP") ? 12 : (categoryName.equals("WAIT") ? 13 : 20));
        return aTaskType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.taskType == 13) {
            ETLTaskThreadManager eTLTaskThreadManager = this.taskManager;
            synchronized (eTLTaskThreadManager) {
                while (this.taskManager.isDependentExists(this.getName())) {
                    try {
                        if (this.taskManager.isActive()) {
                            this.taskManager.wait();
                            continue;
                        }
                        return;
                    }
                    catch (InterruptedException int_exp) {
                    }
                }
                this.taskManager.removeWaitDependency(this.getName());
            }
        }
        String situation = null;
        try {
            situation = this.task.process(this.taskNode);
        }
        catch (Exception prcs_exp) {
            String err = messageManager.getString("ERR_PROCESING_TASK", this.getName());
            Logger.print(40000, this.LOG_CATEGORY, err);
            this.handleException(this.task, this.taskNode, prcs_exp);
            situation = "Exception";
        }
        finally {
            this.task.cleanUp();
        }
        if (this.taskType == 11) {
            String infoMsg = messageManager.getString("INFO_MSG_ENGINE_START");
            Logger.print(20000, this.LOG_CATEGORY, infoMsg);
            ETLEngineContext context = this.taskNode.getContext();
            if (context != null) {
                ETLEngineContext.CollabStatistics stats = context.getStatistics();
                if (stats != null) {
                    stats.collabStarted();
                }
            } else {
                Logger.print(40000, this.LOG_CATEGORY, "Could not locate statistics object - start timestamp is not set.");
            }
        } else if (this.taskType == 13) {
            this.taskManager.clearTaskThread(this.getName());
        }
        String nextTaskParam = this.taskNode.getNextTaskList(situation);
        if (nextTaskParam == null) {
            String errMsg = messageManager.getString("ERR_ILLEGAL_NEXT_TASK", this.getName());
            Logger.print(40000, this.LOG_CATEGORY, errMsg);
            this.handleException(this.task, this.taskNode, new Throwable(errMsg));
            this.taskManager.fireETLEngineExecEvent(2, errMsg);
            this.taskManager.setEngineListener(null);
            return;
        }
        ArrayList nextTaskList = (ArrayList)StringUtil.createStringListFrom(nextTaskParam);
        for (int i = 0; i < nextTaskList.size(); ++i) {
            String nextTaskId = (String)nextTaskList.get(i);
            ETLTaskNode nextETLTaskNode = this.taskNode.getParent().getETLTaskNode(nextTaskId);
            String categoryName = nextETLTaskNode.getTaskType();
            int nextTaskType = this.getTaskType(categoryName);
            try {
                Object context;
                if (nextTaskType == 12) {
                    ETLEngineContext.CollabStatistics stats;
                    context = this.taskNode.getContext();
                    if (context != null && (stats = ((ETLEngineContext)context).getStatistics()) != null) {
                        stats.collabStopped();
                    }
                    this.taskManager.resumeStartThread();
                    if (this.taskType == 11 || this.taskType == 13) continue;
                    return;
                }
                if (nextTaskType == 13) {
                    context = this.taskManager;
                    synchronized (context) {
                        if (!this.taskManager.isTaskThreadExists(nextTaskId)) {
                            if (this.taskManager.isActive()) {
                                ETLTaskThread nextTask = new ETLTaskThread(this.taskManager, nextETLTaskNode);
                                if (nextTask == null) {
                                    throw new RuntimeException("Problem in executing eTL engine...");
                                }
                            } else {
                                this.taskManager.notifyAll();
                            }
                        }
                        if ("Success".equals(situation)) {
                            this.taskManager.markDependencyAsSucceeded(nextTaskId, this.getName());
                        } else {
                            this.taskManager.markDependencyAsFailed(nextTaskId, this.getName());
                        }
                        this.taskManager.notifyAll();
                        continue;
                    }
                }
                if (!this.taskManager.isActive()) continue;
                ETLTaskThread eTLTaskThread = new ETLTaskThread(this.taskManager, nextETLTaskNode);
                continue;
            }
            catch (Exception exp) {
                String err = messageManager.getString("ERR_TASK_THREAD_PROCESSING", exp.toString());
                Logger.printThrowable(40000, this.LOG_CATEGORY, null, err, exp);
                this.handleException(this.task, this.taskNode, exp);
                this.taskManager.fireETLEngineExecEvent(2, err);
                this.taskManager.setEngineListener(null);
            }
        }
        if (this.taskType == 11) {
            this.taskManager.suspendStartThread();
            String infoMsg = messageManager.getString("INFO_ETL_ENGINE_END");
            Logger.print(20000, this.LOG_CATEGORY, infoMsg);
            Iterator throwableIter = Collections.EMPTY_LIST.iterator();
            ETLEngineContext context = this.taskNode.getContext();
            if (context != null) {
                throwableIter = context.getThrowableList().iterator();
            }
            if (throwableIter.hasNext()) {
                do {
                    this.taskManager.fireETLEngineExecEvent(2, (Throwable)throwableIter.next());
                } while (throwableIter.hasNext());
            } else {
                this.taskManager.fireETLEngineExecEvent(1, infoMsg);
            }
            this.taskManager.setEngineListener(null);
        }
    }

    private int handleException(ETLTask aTask, ETLTaskNode curETLTaskNode, Throwable e) {
        try {
            SQLException chainedSqlEx;
            if (this.task != null) {
                aTask.handleException(e instanceof ETLException ? (ETLException)e : new ETLException(e));
            }
            if (e instanceof SQLException && (chainedSqlEx = ((SQLException)e).getNextException()) != null) {
                Logger.printThrowable(10000, this.LOG_CATEGORY, this, "Chained SQLException:", chainedSqlEx);
            }
            if (curETLTaskNode != null) {
                Throwable unwrappedException;
                Throwable throwable = unwrappedException = e instanceof ETLException ? e.getCause() : e;
                if (unwrappedException == null) {
                    unwrappedException = e;
                }
                curETLTaskNode.getContext().putValue("errorMessage", System.getProperty("line.separator", "\n") + unwrappedException.getMessage() + " [while executing " + curETLTaskNode.getId() + "]");
                curETLTaskNode.getContext().addToThrowableList(unwrappedException);
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                String nodeHandle = curETLTaskNode.getNextTaskList("Exception");
                if (nodeHandle == null) {
                    Logger.print(10000, this.LOG_CATEGORY, (Object)this, "Missing next task for exception path!");
                    return 0;
                }
            }
        }
        catch (Exception uex) {
            Logger.printThrowable(40000, this.LOG_CATEGORY, null, "While executing handleException():", uex);
        }
        return -1;
    }

    private void init(ETLTaskThreadManager theTaskManager, ETLTaskNode theETLTaskNode) throws ETLException {
        String errMsg;
        this.taskId = theETLTaskNode.getId();
        this.taskManager = theTaskManager;
        this.taskNode = theETLTaskNode;
        String categoryName = this.taskNode.getTaskType();
        this.taskType = this.getTaskType(categoryName);
        String className = this.taskNode.getParent().getFullQualifiedImplClassName(categoryName);
        try {
            if (className == null) {
                String err = messageManager.getString("ERR_CLASS_NOT_INTASK_MAP", categoryName);
                throw new ETLException(err);
            }
            Class<?> taskClass = Class.forName(className, true, this.getClass().getClassLoader());
            this.task = (ETLTask)taskClass.newInstance();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            errMsg = messageManager.getString("EX_INIT_TASK", className, ie);
            Logger.print(10000, this.LOG_CATEGORY, errMsg);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            errMsg = messageManager.getString("EX_INIT_TASK", className, iae);
            Logger.print(10000, this.LOG_CATEGORY, errMsg);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            errMsg = messageManager.getString("EX_INIT_TASK", className, cnfe);
            Logger.print(10000, this.LOG_CATEGORY, errMsg);
        }
        if (this.taskType == 13) {
            ArrayList<String> dependentTaskList = new ArrayList<String>();
            String dependsStr = this.taskNode.getDependsOn();
            StringTokenizer taskList = new StringTokenizer(dependsStr, ",");
            while (taskList.hasMoreElements()) {
                dependentTaskList.add(taskList.nextToken());
            }
            WaitTask waitTask = (WaitTask)this.task;
            waitTask.setDependentTaskIds(dependsStr);
            this.taskManager.addWaitDependency(this.getName(), waitTask);
        }
    }
}

