/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngine;
import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class CleanupTask
extends SimpleTask {
    private static final String LOG_CATEGORY = CleanupTask.class.getName();
    private ETLTaskNode taskNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        if (this.taskNode == null) {
            Logger.print(10000, LOG_CATEGORY, this.DN + "No associated task node!  Nothing executed in cleanUp().");
            return;
        }
        try {
            int releasedCt;
            block16: {
                DBConnectionFactory factory = DBConnectionFactory.getInstance();
                releasedCt = 0;
                if (factory != null) {
                    ETLEngineContext context = this.taskNode.getContext();
                    boolean isActivityCleanupTask = !this.isThisCollaborationCleanupTask();
                    try {
                        if (!isActivityCleanupTask) {
                            Collection closeList = context.getConnectionsToClose();
                            for (Connection aConn : closeList) {
                                Logger.print(10000, LOG_CATEGORY, this.DN + "Closing connection " + aConn);
                                factory.closeConnection(aConn);
                                ++releasedCt;
                            }
                        }
                        SQLPart defragPart = this.taskNode.getStatement("defragStatement");
                        Connection idbConnection = null;
                        if (defragPart == null || defragPart.getSQL() == null || "".equals(defragPart.getSQL())) break block16;
                        try {
                            idbConnection = this.getConnection(defragPart.getConnectionPoolName(), this.taskNode.getParent().getConnectionDefList());
                            factory.shutdown(idbConnection, true, defragPart.getSQL());
                            factory.closeConnection(idbConnection);
                        }
                        catch (Exception ex) {
                            try {
                                Logger.printThrowable(10000, LOG_CATEGORY, this.DN + this, "Could not shut down DB associated with connection " + idbConnection, ex);
                                factory.closeConnection(idbConnection);
                            }
                            catch (Throwable throwable) {
                                factory.closeConnection(idbConnection);
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Logger.print(10000, LOG_CATEGORY, this.DN + "Executing node-level release commands.");
                        this.release(this.taskNode);
                    }
                }
            }
            MessageManager messageManager = MessageManager.getManager("com.sun.etl.engine.impl");
            String msg = messageManager.getString("MSG_cleanup_finished");
            this.taskNode.fireETLEngineLogEvent(msg);
            msg = messageManager.getString("MSG_cleanup_finished_specs", new Integer(releasedCt));
            Logger.print(10000, LOG_CATEGORY, this.DN + msg);
        }
        catch (Exception e) {
            Logger.printThrowable(10000, LOG_CATEGORY, this.DN, e.getMessage(), e);
        }
        finally {
            this.taskNode = null;
        }
    }

    public void handleException(BaseException ex) {
        Logger.print(10000, LOG_CATEGORY, (Object)this.DN, "Handling Exception for cleanup task....");
        Logger.printThrowable(10000, LOG_CATEGORY, this.DN, ex.getMessage(), ex);
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String process(ETLTaskNode node) throws ETLException {
        block10: {
            block11: {
                boolean isTruncate = false;
                Logger.print(10000, LOG_CATEGORY, this.DN + "Processing cleanup task...");
                this.taskNode = node;
                if (!StringUtil.isNullString(this.taskNode.getDisplayName())) {
                    this.DN = this.DN + " <" + this.taskNode.getDisplayName().trim() + ">";
                }
                Connection con = null;
                Statement stmt = null;
                MessageManager messageManager = MessageManager.getManager("com.sun.etl.engine.impl");
                if (node == null) break block11;
                SQLPart sqlPart = node.getStatement("dropStatement");
                if (sqlPart == null) {
                    sqlPart = node.getStatement("truncateBeforeProcessStatement");
                    isTruncate = true;
                }
                if (sqlPart == null) break block10;
                String cleanUpSQL = sqlPart.getSQL();
                String cleanUpSQLConName = sqlPart.getConnectionPoolName();
                try {
                    List connList = node.getParent().getConnectionDefList();
                    con = this.getConnection(cleanUpSQLConName, connList);
                    if (isTruncate) {
                        Logger.print(10000, LOG_CATEGORY, this.DN + "Got connection for truncate: " + con);
                    } else {
                        Logger.print(10000, LOG_CATEGORY, this.DN + "Got connection for drop: " + con);
                    }
                    stmt = con.createStatement();
                    String attemptDropMsg = messageManager.getString(isTruncate ? "MSG_cleanup_truncate_attempt" : "MSG_cleanup_drop_attempt");
                    Logger.print(10000, LOG_CATEGORY, this.DN + attemptDropMsg);
                    node.fireETLEngineLogEvent(attemptDropMsg);
                    StringTokenizer st = new StringTokenizer(cleanUpSQL, Character.toString('\uffff'));
                    int tableCt = 0;
                    while (st.hasMoreElements()) {
                        String sql = st.nextToken();
                        ++tableCt;
                        String dropSqlMsg = messageManager.getString(isTruncate ? "MSG_common_truncate_stmt" : "MSG_common_drop_stmt", sql);
                        Logger.print(10000, LOG_CATEGORY, this.DN + dropSqlMsg);
                        node.fireETLEngineLogEvent(dropSqlMsg);
                        stmt.addBatch(sql);
                    }
                    int[] status = stmt.executeBatch();
                    con.commit();
                    int dropCt = 0;
                    for (int i = 0; i < status.length; ++i) {
                        dropCt += status[i] != -3 ? 1 : 0;
                    }
                    String dropCountMsg = messageManager.getString(isTruncate ? "MSG_cleanup_truncate_count" : "MSG_cleanup_drop_count", new Integer(dropCt), new Integer(tableCt));
                    Logger.print(10000, LOG_CATEGORY, this.DN + dropCountMsg);
                    node.fireETLEngineLogEvent(dropCountMsg);
                }
                catch (Exception ignore) {
                    this.closeStatement(stmt);
                    node.getParent().getContext().closeAndReleaseLater(con);
                    break block10;
                    catch (Throwable throwable) {
                        this.closeStatement(stmt);
                        node.getParent().getContext().closeAndReleaseLater(con);
                        throw throwable;
                    }
                }
                this.closeStatement(stmt);
                node.getParent().getContext().closeAndReleaseLater(con);
                break block10;
            }
            Logger.print(10000, LOG_CATEGORY, this.DN + "No associated task node!");
        }
        Logger.print(10000, LOG_CATEGORY, this.DN + "Finished cleanup task.");
        return "Success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Connection con, String sql) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            if (sql != null) {
                stmt.executeUpdate(sql);
            }
        }
        catch (SQLException ignore) {
            Logger.print(10000, LOG_CATEGORY, (Object)(this.DN + "Error occurred during execution of SQL statement."), ignore);
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(List sqlParts, List conDefList) throws SQLException, Exception {
        for (SQLPart part : sqlParts) {
            String sql = part.getSQL();
            String poolName = part.getConnectionPoolName();
            Connection con = null;
            try {
                con = this.getConnection(poolName, conDefList);
                if (sql == null) continue;
                this.execute(con, sql);
            }
            finally {
                DBConnectionFactory.getInstance().closeConnection(con);
            }
        }
    }

    private void release(ETLTaskNode node) {
        ETLEngine engine = node.getParent();
        List conDefList = engine.getConnectionDefList();
        try {
            if (!engine.isRunningOnAppServer()) {
                return;
            }
            List sqlParts = node.getOptionalTasks();
            if (sqlParts.size() != 0) {
                this.execute(sqlParts, conDefList);
            }
        }
        catch (Exception e) {
            Logger.print(40000, LOG_CATEGORY, (Object)(this.DN + "Failed to execute on appConn."), e);
        }
    }

    private boolean isThisCollaborationCleanupTask() {
        String nextTaskList;
        boolean ret = false;
        if (this.taskNode != null && (nextTaskList = this.taskNode.getNextTaskList("Success")).indexOf("STOP") >= 0) {
            ret = true;
        }
        return ret;
    }
}

