/**************************************************************
*   
*   Creation Date: <97/06/06 20:22:44 samuel>
*   Time-stamp: <2001/09/22 14:31:44 samuel>
*   
*	<wrapper.h>
*	
*	
*   
*   Copyright (C) 1997, 1999, 2000, 2001 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/

#ifndef _WRAPPER_H
#define _WRAPPER_H

#include <sys/types.h>

#include "prom.h"
#include "mac_registers.h"
#include "multiplexer.h"
#include "mmu_mappings.h"

extern int multiplexer( int selector, int arg1, int arg2, int arg3, int arg4 );
extern int fast_multiplexer( int selector, int arg1, int arg2, int arg3, int arg4 );

typedef int (*multiplexer4_t)( int sel, int sid, int, int, int, int);
typedef int (*multiplexer3_t)( int sel, int sid, int, int, int );
typedef int (*multiplexer2_t)( int sel, int sid, int, int );
typedef int (*multiplexer1_t)( int sel, int sid, int );
typedef int (*multiplexer0_t)( int sel, int sid );

extern int g_session_id;

struct linux_page;

#define _multiplexer4(sel,a1,a2,a3,a4) \
	((multiplexer4_t)&fast_multiplexer)(sel, g_session_id, (int)(a1),(int)(a2),(int)(a3),(int)(a4))
#define _multiplexer3(sel,a1,a2,a3) \
	((multiplexer3_t)&fast_multiplexer)(sel, g_session_id, (int)(a1),(int)(a2),(int)(a3))
#define _multiplexer2(sel,a1,a2) \
	((multiplexer2_t)&fast_multiplexer)(sel, g_session_id, (int)(a1),(int)(a2))
#define _multiplexer1(sel,a1) \
	((multiplexer1_t)&fast_multiplexer)(sel, g_session_id, (int)(a1))
#define _multiplexer0(sel) \
	((multiplexer0_t)&fast_multiplexer)(sel, g_session_id)
#define _sc_multiplexer0(sel) \
	((multiplexer0_t)&multiplexer)(sel, g_session_id)

/************************************************************************/
/*	Convenience Inliness						*/
/************************************************************************/

static inline int _kernel_init( ulong session_magic ) { 
	return _multiplexer1( fInit, session_magic ); }

static inline void _kernel_cleanup( void ) { 
	(void) _multiplexer0( fCleanup ); }

static inline ulong _get_mregs( void ) { 
	return _multiplexer0( fGetMregs ); }

static inline ulong _get_mregs_phys( void ) { 
	return _multiplexer0( fGetMregsPhys ); }

static inline void _spr_changed( void ) {
	_multiplexer0( fSprChanged ); }

static inline void _breakpoint_flags( int flags ) { 
	_multiplexer1( fBreakpointFlags, flags ); }

static inline void _add_io_range( ulong mbase, int size, void *usr_data ) { 
	_multiplexer3( fAddIORange, mbase, size, usr_data ); }

static inline void _remove_io_range( ulong mbase, int size ) {
	_multiplexer2( fRemoveIORange, mbase, size ); }

static inline void _set_mac_ram( ulong lv_base, ulong lv_size, ulong mv_base ) {
	_multiplexer3( fSetMacRam, lv_base, lv_size, mv_base ); }

static inline ulong _get_kernel_version( void ) {
	return _sc_multiplexer0( fGetKernelVersion ); }

static inline ulong _get_mol_mod_version( void ) {
	return _sc_multiplexer0( fGetMolModVersion ); }

static inline size_t _prom_get_node_size( mol_device_node_t *node ) {
	return _multiplexer1( fPromGetNodeSize, node ); }

static inline int _prom_copy_node( mol_device_node_t *dest, mol_device_node_t *src, int bufsize ) {
	return _multiplexer3( fPromCopyNode, dest, src, bufsize ); }

static inline int _get_PTE( int segment, ulong lv_addr, ulong ret_pte[2] ) {
	return _multiplexer3( fGetPTE, segment, lv_addr, ret_pte ); }

static inline int _translate_dea( int context, ulong ea, mol_PTE_t *pte ) {
	return _multiplexer3( fTranslateDEa, context, ea, pte ); }

static inline int _translate_iea( int context, ulong ea, mol_PTE_t *pte ) {
	return _multiplexer3( fTranslateIEa, context, ea, pte ); }

static inline int _dbg_get_physical_page( ulong lvptr, struct linux_page *pinfo_ret ) {
	return _multiplexer2( fGetPhysicalAddr, lvptr, pinfo_ret ); }

static inline void _emulate_tlbie( ulong page_index ) {
	_multiplexer1( fEmulateTLBIE, page_index ); }

static inline void _emulate_tlbia( void ) {
	_multiplexer0( fEmulateTLBIA ); }

static inline void _kernel_memmove( char *src, char *dest, size_t size ) {
	_multiplexer3( fKernelMemmove, src, dest, size ); }

static inline void _add_mmu_mapping( struct mmu_mapping *m ) {
	_multiplexer1( fAddMMUMapping, m ); }

static inline void _remove_mmu_mapping( struct mmu_mapping *m ) {
	_multiplexer1( fRemoveMMUMapping, m ); }

static inline void _msr_changed( void ) {
	_multiplexer0( fMsrChanged ); }

static inline void _setup_fb_accel( char *lvbase, int bytes_per_row, int height ) {
	_multiplexer3( fSetupFBAccel, lvbase, bytes_per_row, height); }

static inline int _get_dirty_fb_lines( short *rettable, int table_size_in_bytes ) {
	return _multiplexer2( fGetDirtyFBLines, rettable, table_size_in_bytes ); }

static inline void _get_pvr( ulong *ret_pvr ) {
	_multiplexer1( fGetPVR, ret_pvr ); }

static inline int _track_dirty_RAM( char *lvbase, size_t size ) {
	return _multiplexer2( fTrackDirtyRAM, lvbase, size ); }

static inline size_t _get_dirty_RAM( char *retbuf ) {
	return _multiplexer1( fGetDirtyRAM, retbuf ); }

static inline void _set_dirty_RAM( char *dirtybuf ) {
	_multiplexer1( fSetDirtyRAM, dirtybuf ); }

static inline char * _get_kvarbase( void ) {
	return (char*)_multiplexer0( fGetKvarBase ); }

static inline int _get_performance_info( int index, char *buf, int size, int *retv ) {
	return _multiplexer4( fGetPerformanceInfo, index, buf, size, retv ); }

static inline ulong _get_tb_frequency( void ) {
	return _multiplexer0( fGetTBFrequency ); }

#endif
