/* 
 *   Creation Date: <1999/10/31 18:16:04 samuel>
 *   Time-stamp: <2001/06/16 19:08:00 samuel>
 *   
 *	<booter.h>
 *	
 *	World interface to NewWorld booting replacement
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_BOOTER
#define _H_BOOTER

extern void 	booter_init( void );
extern void 	booter_cleanup( void );
extern void 	booter_startup( void );

extern void 	newworld_booter_init( void );
extern void 	bootx_init( void );
extern void 	oldworld_booter_init( void );
extern void 	elf_booter_init( void );

typedef struct {
	// Booter
	void	(*booter_startup)( void );
	void	(*booter_cleanup)( void );
	
	// Mouse/keyboard interface
	void	(*adb_key_event)( unsigned char key );
	void	(*zap_keyboard)( void );
	void	(*mouse_event)( int dx, int dy, int buttons );

	// Config
	char	*nvram_image_name;
	char	*oftree_filename;
} platform_expert_ops_t;

enum { 
	/* mouse_event buttons */
	/* WARNING: hardcoded in console.c and xvideo.c */
	kButton1=1, kButton2=2, kButton3=4, kButtonMask = 7
};


extern platform_expert_ops_t gPE;

// Useful inlines

static inline void PE_adb_key_event( unsigned char key )
	{ if( gPE.adb_key_event ) gPE.adb_key_event(key); }
static inline void PE_zap_keyboard( void )
	{ if( gPE.zap_keyboard ) gPE.zap_keyboard(); }
static inline void PE_mouse_event( int dx, int dy, int buttons ) 
	{ if( gPE.mouse_event ) gPE.mouse_event(dx,dy,buttons); }


// Boot method queries

extern int _boot_method_globals_inited;
extern int _boot_is_newworld, _boot_is_oldworld, _boot_is_bootx, _boot_is_elf;
extern void _init_boot_method_globals( void );
#define INIT_GLOBALS if( !_boot_method_globals_inited ) _init_boot_method_globals()
static inline int is_newworld_boot( void ) { INIT_GLOBALS; return _boot_is_newworld; };
static inline int is_oldworld_boot( void ) { INIT_GLOBALS; return _boot_is_oldworld; }
static inline int is_bootx_boot( void ) { INIT_GLOBALS; return _boot_is_bootx; }
static inline int is_elf_boot( void ) { INIT_GLOBALS; return _boot_is_elf; }
#undef INIT_GLOBALS

#endif   /* _H_BOOTER */
