/**************************************************************
*   
*   Creation Date: <2000-01-01 04:32:32 samuel>
*   Time-stamp: <2000/12/31 04:18:57 samuel>
*   
*	<offscreen_video.c>
*	
*	Simple offscreen video driver (fallback)
*   
*   Copyright (C) 2000 Samuel Rydh
*   
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*   
**************************************************************/


#include "mol_config.h"

/* #define VERBOSE */

#include <sys/mman.h>
#include <sys/ioctl.h>
#include <pthread.h>

#include "verbose.h"
#include "debugger.h"
#include "memory.h"
#include "mouse_sh.h"
#include "video_module.h"

SET_VERBOSE_NAME("offscreen_video")


typedef struct ov_state
{
	int 		is_open;
	video_desc_t 	vmode;
} ov_state_t;

static ov_state_t ov[1];

/* prototypes */
static int 	init( video_module_t *mod );
static void 	cleanup( video_module_t *mod );

static void 	setcmap(char *pal);
static int	vopen( video_desc_t *mode );
static void	vclose( void );


/* Video module interface */
video_module_t offscreen_video_module  = {
	"offscreen_video",
	init,
	cleanup,
	vopen,
	vclose,
	NULL,			/* vrefresh */
	setcmap,

	NULL,			/* supported video modes */
	NULL			/* next */
};


/**************************************************************
*  	Implementation  
**************************************************************/

static int
init( video_module_t *m )
{
	VPRINT("init\n");

	memset( ov, 0, sizeof( ov_state_t ) );
	return 0;
}


static void
cleanup( video_module_t *m ) 
{
	VPRINT("cleanup\n");

	if( ov->is_open )
		vclose();
}

static int
vopen( video_desc_t *vm )
{
	VPRINT("vopen\n");

	if( ov->is_open ) {
		LOG("Offscreen buffer opened twice!\n");
		/* best no to fail here */
	}
	
	vm->lvbase = map_zero( NULL, FBBUF_SIZE(vm) );

	vm->mmu_flags = MAPPING_FORCE_CACHE;
	vm->map_base = 0;

	if( !vm->lvbase )
		vm->mmu_flags |= MAPPING_SCRATCH;

	ov->vmode = *vm;
	ov->is_open = 1;
	return 0;
}

static void
vclose( void )
{
	VPRINT("vclose\n");

	if( !ov->is_open )
		return;
	ov->is_open = 0;

	if( ov->vmode.lvbase )
		munmap( ov->vmode.lvbase, FBBUF_SIZE( &ov->vmode ));
}


/* format is [R,G,B] * 256 */
static void 
setcmap(char *pal)
{
}

