/**************************************************************
*   
*   Creation Date: <1998-11-10 08:57:52 samuel>
*   Time-stamp: <2000/09/30 20:42:53 samuel>
*   
*	<pic.c>
*	
*	Interrupt controller
*   
*   Copyright (C) 1997, 1999, 2000 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/

#ifndef _H_PIC
#define _H_PIC

/*  If interrupt_line and MSR_EE is set, then
 *  an interrupt should be taken.
 */
extern int	interrupt_line;

/* 
 * Device drivers may use either of two interrupt models
 *
 * 	1.  irq_line_hi / irq_line_low.
 *	    An interrupt is generated on the positive edge
 *	    
 * 	2.  irq_interrupt
 *	    An interrupt is always generated
 */ 
extern void irq_line_hi( int irq );
extern void irq_line_low( int irq );

extern int pic_init( void );


#endif   /* _H_PIC */

