/* 
 *   Creation Date: <1999/12/22 23:26:44 samuel>
 *   Time-stamp: <2001/02/24 21:31:56 samuel>
 *   
 *	<mouse_sh.h>
 *	
 *	Mouse interface (also included from MacOS)
 *   
 *   Copyright (C) 1999, 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_MOUSE_SH
#define _H_MOUSE_SH

#if defined(__linux__)
#include "timer.h"
extern ullong get_mouse_moved_stamp( void );

extern void mouse_move_to( int x, int y );
extern void mouse_move( int dx, int dy );
extern void mouse_but_event( int butevent );
extern void mouse_event( int dx, int dy, int cur_buts );

extern void use_hw_cursor( int flag );
#endif

/* OSI_GET_MOUSE, returned in r4-r8 */
typedef struct {
	int	absx,absy;		/* IMPORTANT: If this struct is */
	int	dx,dy;			/* modified, then the drivers	*/
	int	use_hw_curs;		/* must be fixed too! 		*/
} osi_mouse_t;
#define SIZEOF_OSI_MOUSE_T		20


/* return status of OSI_GET_MOUSE (and also used in the implementation) */
enum {
	/* XXX: mouse up/down values hardcoded in osi_mouse.c */
	kMouseEvent_Down1	= 1,	/* 1 as long the button is down */	
	kMouseEvent_Down2	= 2,
	kMouseEvent_Down3	= 4,
	kMouseEvent_ButMask	= 7,

	kMouseEvent_Up1		= 8,	/* not returned by OSI_GET_MOUSE */
	kMouseEvent_Up2		= 16,
	kMouseEvent_Up3		= 32,

	kMouseEvent_MoveDelta	= 64,
	kMouseEvent_MoveTo	= 128
};

#endif   /* _H_MOUSE_SH */
