/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.idbDataOutputStream;

class DoubleColumn
extends Column {
    static final double NULL_VALUE = Double.NaN;
    static int time;

    DoubleColumn(Table table, String string) throws SQLException, NumberFormatException {
        super(table, string, 8);
        this.nullObj = new Double(Double.NaN);
        this.type = 8;
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
    }

    boolean compare(int n, Object object, int n2, boolean bl) throws SQLException {
        return DoubleColumn.compareVals(this.getByRow(n), object, n2, bl);
    }

    static boolean compareVals(Object object, Object object2, int n, boolean bl) throws SQLException {
        double d = ((Number)object).doubleValue();
        double d2 = ((Number)object2).doubleValue();
        if (object instanceof Double && object2 instanceof Double) {
            if (bl) {
                if (n == 1) {
                    if (((Double)object).isNaN() && ((Double)object2).isNaN()) {
                        return true;
                    }
                } else if (n == 4 && ((Double)object).isNaN() && ((Double)object2).isNaN()) {
                    return false;
                }
            } else {
                if (((Double)object).isNaN()) {
                    return false;
                }
                if (((Double)object2).isNaN()) {
                    return false;
                }
            }
        }
        switch (n) {
            case 1: {
                return d == d2;
            }
            case 4: {
                return d != d2;
            }
            case 7: {
                return d < d2;
            }
            case 8: {
                return d <= d2;
            }
            case 5: {
                return d > d2;
            }
            case 6: {
                return d >= d2;
            }
        }
        throw new SQLException("Internal error: undefined operation: " + n, "XOPEN?");
    }

    Object getByRow(int n) throws SQLException {
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                double d = this.cTable.dataIn.readDouble();
                this.cTable.rndFile.freeReadAhead();
                object = new Double(d);
            }
            catch (Exception exception) {
                this.cTable.rndFile.freeReadAhead();
                throw new SQLException("Problem reading column, " + this.colName + ", in table, " + this.cTable.tableName + ", " + exception.toString());
            }
            this.rowCache.add(object, n);
        }
        return object;
    }

    int getHash(Object object) {
        double d = ((Number)object).doubleValue();
        long l = Double.doubleToLongBits(d);
        return (int)(l >> 32 ^ l);
    }

    boolean hashPreservesOrder() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isNull(Object object) {
        Double d = (Double)object;
        return d.equals(this.nullObj);
    }

    boolean numeric() {
        return true;
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                if (object == null) {
                    super.setProperty(n, null);
                    return;
                }
                Double d = new Double((String)object);
                if (d == Double.NaN) {
                    throw new NumberFormatException(object.toString());
                }
                super.setProperty(n, d);
                break;
            }
            default: {
                super.setProperty(n, object);
            }
        }
    }

    Object toObject(Object object) {
        Double d;
        if (object == null) {
            return this.nullObj;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return this.nullObj;
            }
            try {
                d = new Double(string);
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof Number) {
                double d2 = ((Number)object).doubleValue();
                d = new Double(d2);
            } else {
                return null;
            }
        }
        if (d == Double.NaN && !this.allowAccidentalNulls) {
            return null;
        }
        return d;
    }

    public String toString(Object object) {
        String string = ((Double)object).isNaN() ? "NULL" : object.toString();
        return string;
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        double d = (Double)object;
        idbDataOutputStream2.writeDouble(d);
    }
}

